/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetPageRespVO;
import com.elitesland.scp.domain.entity.order.QScpDemandSetDO;
import com.elitesland.scp.infr.dto.order.ScpDemandSetDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class ScpDemandSetRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpDemandSetDO scpDemandSetDO = QScpDemandSetDO.scpDemandSetDO;
    private final QBean<ScpDemandSetPageRespVO> pageList;
    private final QBean<ScpDemandSetDTO> demandSetList;

    public long countDemandSet(ScpDemandSetPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)scpDemandSetDO.count()).from((EntityPath)scpDemandSetDO);
        jpaQuery.where(this.whereDemandSetPage(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpDemandSetPageRespVO> queryDemandSet(ScpDemandSetPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)scpDemandSetDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpDemandSetDO);
        jpaQuery.where(this.whereDemandSetPage(paramVO));
        return jpaQuery.fetch();
    }

    public List<ScpDemandSetPageRespVO> queryDemandSetList(ScpDemandSetPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.pageList).from((EntityPath)scpDemandSetDO);
        jpaQuery.where(this.whereDemandSetPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereDemandSetPage(ScpDemandSetPageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandCode())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandCode.like(paramVO.getDemandCode() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.type.eq((Object)paramVO.getType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandName())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandName.like(paramVO.getDemandName() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)paramVO.getDemandDateFrom()) && !ObjectUtils.isEmpty((Object)paramVO.getDemandDateTo())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandDate.between((Comparable)paramVO.getDemandDateFrom(), (Comparable)paramVO.getDemandDateTo()));
        }
        if (paramVO.getIsPushed() != null) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.isPushed.eq(paramVO.getIsPushed()));
        }
        if (paramVO.getStatus() != null) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.status.eq(paramVO.getStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDocType())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.docType.eq((Object)paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getStoreCode())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.storeCode.eq((Object)paramVO.getStoreCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getRegionCode())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.regionCode.eq((Object)paramVO.getRegionCode()));
        }
        if (paramVO.getAllFlag() != null && paramVO.getAllFlag().booleanValue()) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.regionCode.eq((Object)"all").or((Predicate)ScpDemandSetRepoProc.scpDemandSetDO.storeCode.eq((Object)"all")));
        }
        if (paramVO.getExpireTime() != null) {
            LocalDateTime endDateTime = paramVO.getExpireTime().toLocalDate().atTime(LocalTime.MAX);
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.expireTime.goe((Comparable)paramVO.getExpireTime()).and((Predicate)ScpDemandSetRepoProc.scpDemandSetDO.expireTime.loe((Comparable)endDateTime)));
        }
        if (StringUtils.isNotBlank((String)paramVO.getCreateType())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.createType.eq((Object)paramVO.getCreateType()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    private Predicate whereDemandSet(ScpDemandSetParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandCode())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandCode.eq((Object)paramVO.getDemandCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getType())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.type.eq((Object)paramVO.getType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDemandName())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandName.eq((Object)paramVO.getDemandName()));
        }
        if (paramVO.getDemandDate() != null) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandDate.eq((Object)paramVO.getDemandDate()));
        }
        if (paramVO.getDemandDateFrom() != null) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandDate.goe((Comparable)paramVO.getDemandDateFrom()));
        }
        if (paramVO.getDemandDateTo() != null) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandDate.loe((Comparable)paramVO.getDemandDateTo()));
        }
        if (paramVO.getIsPushed() != null) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.isPushed.eq(paramVO.getIsPushed()));
        }
        if (paramVO.getStatus() != null) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.status.eq(paramVO.getStatus()));
        }
        if (paramVO.getExpireTime() != null) {
            LocalDateTime endDateTime = paramVO.getExpireTime().toLocalDate().atTime(LocalTime.MAX);
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.expireTime.goe((Comparable)paramVO.getExpireTime()).and((Predicate)ScpDemandSetRepoProc.scpDemandSetDO.expireTime.loe((Comparable)endDateTime)));
        }
        if (CollUtil.isNotEmpty(paramVO.getDemandNames())) {
            predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.demandName.in(paramVO.getDemandNames()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpDemandSetDTO> findDemandSetByParam(ScpDemandSetParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.demandSetList).from((EntityPath)scpDemandSetDO);
        jpaQuery.where(this.whereDemandSet(paramVO));
        jpaQuery.orderBy(ScpDemandSetRepoProc.scpDemandSetDO.id.asc());
        return jpaQuery.fetch();
    }

    public void enableDemandSet(List<Long> ids, Boolean enable) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scpDemandSetDO).set((Path)ScpDemandSetRepoProc.scpDemandSetDO.status, (Object)enable).where(new Predicate[]{ScpDemandSetRepoProc.scpDemandSetDO.id.in(ids)});
        update.execute();
    }

    public long deleteByIds(List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScpDemandSetRepoProc.scpDemandSetDO.id.in(ids));
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)scpDemandSetDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public void updateDemandSetMsgByIds(List<Long> ids, String msg) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scpDemandSetDO).set((Path)ScpDemandSetRepoProc.scpDemandSetDO.computeMsg, (Object)msg).where(new Predicate[]{ScpDemandSetRepoProc.scpDemandSetDO.id.in(ids)});
        update.execute();
    }

    public void updateDemandSetPushMsgById(List<Long> ids, String msg) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scpDemandSetDO).set((Path)ScpDemandSetRepoProc.scpDemandSetDO.pushMsg, (Object)msg).where(new Predicate[]{ScpDemandSetRepoProc.scpDemandSetDO.id.in(ids)});
        update.execute();
    }

    public void completePushById(Long id) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scpDemandSetDO).set((Path)ScpDemandSetRepoProc.scpDemandSetDO.isPushed, (Object)Boolean.TRUE).set((Path)ScpDemandSetRepoProc.scpDemandSetDO.pushMsg, (Object)"\u63a8\u9001\u5b8c\u6bd5").where(new Predicate[]{ScpDemandSetRepoProc.scpDemandSetDO.id.eq((Object)id)});
        update.execute();
    }

    public Boolean getDemandSetStatusById(Long demandSetId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)ScpDemandSetRepoProc.scpDemandSetDO.status).from((EntityPath)scpDemandSetDO);
        jpaQuery.where((Predicate)ScpDemandSetRepoProc.scpDemandSetDO.id.eq((Object)demandSetId));
        return (Boolean)jpaQuery.fetchOne();
    }

    public ScpDemandSetRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(ScpDemandSetPageRespVO.class, (Expression[])new Expression[]{ScpDemandSetRepoProc.scpDemandSetDO.id, ScpDemandSetRepoProc.scpDemandSetDO.type, ScpDemandSetRepoProc.scpDemandSetDO.demandCode, ScpDemandSetRepoProc.scpDemandSetDO.demandName, ScpDemandSetRepoProc.scpDemandSetDO.demandDate, ScpDemandSetRepoProc.scpDemandSetDO.status, ScpDemandSetRepoProc.scpDemandSetDO.computeMsg, ScpDemandSetRepoProc.scpDemandSetDO.isPushed, ScpDemandSetRepoProc.scpDemandSetDO.creator, ScpDemandSetRepoProc.scpDemandSetDO.createUserId, ScpDemandSetRepoProc.scpDemandSetDO.createTime, ScpDemandSetRepoProc.scpDemandSetDO.updater, ScpDemandSetRepoProc.scpDemandSetDO.modifyUserId, ScpDemandSetRepoProc.scpDemandSetDO.modifyTime, ScpDemandSetRepoProc.scpDemandSetDO.remark, ScpDemandSetRepoProc.scpDemandSetDO.docType, ScpDemandSetRepoProc.scpDemandSetDO.regionCode, ScpDemandSetRepoProc.scpDemandSetDO.storeCode, ScpDemandSetRepoProc.scpDemandSetDO.storeName, ScpDemandSetRepoProc.scpDemandSetDO.expireTime, ScpDemandSetRepoProc.scpDemandSetDO.createType});
        this.demandSetList = Projections.bean(ScpDemandSetDTO.class, (Expression[])new Expression[]{ScpDemandSetRepoProc.scpDemandSetDO.id, ScpDemandSetRepoProc.scpDemandSetDO.type, ScpDemandSetRepoProc.scpDemandSetDO.demandCode, ScpDemandSetRepoProc.scpDemandSetDO.demandName, ScpDemandSetRepoProc.scpDemandSetDO.demandDate, ScpDemandSetRepoProc.scpDemandSetDO.status, ScpDemandSetRepoProc.scpDemandSetDO.computeMsg, ScpDemandSetRepoProc.scpDemandSetDO.isPushed, ScpDemandSetRepoProc.scpDemandSetDO.creator, ScpDemandSetRepoProc.scpDemandSetDO.createUserId, ScpDemandSetRepoProc.scpDemandSetDO.createTime, ScpDemandSetRepoProc.scpDemandSetDO.updater, ScpDemandSetRepoProc.scpDemandSetDO.modifyUserId, ScpDemandSetRepoProc.scpDemandSetDO.modifyTime, ScpDemandSetRepoProc.scpDemandSetDO.remark});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

