/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.job.service;

import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandSetSaveVO;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import com.elitesland.scp.application.service.order.ScpOrderTemplateService;
import com.elitesland.scp.domain.entity.order.ScpDemandSetDO;
import com.elitesland.scp.domain.entity.order.ScpOrderTemplateDO;
import com.elitesland.scp.domain.service.order.ScpDemandSetDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.order.ScpDemandSetRepo;
import com.elitesland.scp.infr.repo.order.ScpOrderTemplateRepo;
import com.elitesland.scp.job.service.ScpDemandSetJobService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.SysUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpDemandSetJobServiceImpl
implements ScpDemandSetJobService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandSetJobServiceImpl.class);
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final ScpDemandSetDomainService scpDemandSetDomainService;
    private final ScpStoreDemandCalendarService scpStoreDemandCalendarService;
    private final ScpOrderTemplateService orderTemplateService;
    private final ScpOrderTemplateRepo scpOrderTemplateRepo;
    private final ScpDemandSetRepo scpDemandSetRepo;
    private final SysSettingService sysSettingService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoCreateDemandSet() {
        int n;
        ScpCalendarStoreQueryParamVO paramVO = new ScpCalendarStoreQueryParamVO();
        paramVO.setWorkStatus(ScpUdcEnum.CALENDAR_WORK_STATUS_W.getValueCode());
        paramVO.setFindDate(LocalDate.now());
        Boolean isExist = this.scpStoreDemandCalendarService.isExistStoreByDateAndWorkStatus(paramVO);
        if (!isExist.booleanValue()) {
            return;
        }
        LocalDate demandDate = LocalDate.now();
        List<ScpDemandSetDO> setDOS = this.scpDemandSetRepo.findByDemandDate(demandDate.atStartOfDay());
        if (CollectionUtils.isNotEmpty(setDOS)) {
            log.info("\u8ba2\u8d27\u96c6\u5df2\u751f\u6210\uff0c\u65e0\u9700\u91cd\u590d\u751f\u6210");
            return;
        }
        List<ScpOrderTemplateDO> templateDOS = this.scpOrderTemplateRepo.findByIsActive(1);
        ArrayList<ScpDemandSetDO> scpDemandSetDOS = new ArrayList<ScpDemandSetDO>();
        int times = SysUtils.getAutoOrderSetNumSetting();
        templateDOS.forEach(template -> {
            if (!demandDate.isBefore(template.getStartDate()) && !demandDate.isAfter(template.getEndDate())) {
                String bkst = null;
                bkst = ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode().equals(template.getType()) ? "BKST" : "BKWH";
                for (int n = 0; n < times; ++n) {
                    String storeDemandCode = this.rmiSysUserRpcService.sysNumberRuleGenerateCode(bkst, new ArrayList<String>());
                    ScpDemandSetDO demandSetSaveVO = new ScpDemandSetDO();
                    demandSetSaveVO.setDemandCode(storeDemandCode);
                    demandSetSaveVO.setType(template.getType());
                    demandSetSaveVO.setDemandDate(demandDate.atStartOfDay());
                    demandSetSaveVO.setDemandName("\u95e8\u5e97\u8ba2\u8d27\u96c6" + this.convertDate(demandDate.atStartOfDay()) + storeDemandCode.substring(storeDemandCode.length() - 3));
                    demandSetSaveVO.setExpireTime(LocalDateTime.of(demandDate.atStartOfDay().toLocalDate(), template.getDeadlineTime()));
                    demandSetSaveVO.setStoreName(template.getStoreName());
                    demandSetSaveVO.setStoreCode(template.getStoreCode());
                    demandSetSaveVO.setRegionCode(template.getRegionCode());
                    demandSetSaveVO.setDocType(template.getDocType());
                    demandSetSaveVO.setCreateType(UdcEnum.SCP_ORDER_SET_CREATE_TYPE_01.getValueCode());
                    scpDemandSetDOS.add(demandSetSaveVO);
                }
            }
        });
        scpDemandSetDOS.sort(new Comparator<ScpDemandSetDO>(){

            @Override
            public int compare(ScpDemandSetDO o1, ScpDemandSetDO o2) {
                boolean isEmpty2;
                String storeCode1 = o1.getStoreCode();
                String storeCode2 = o2.getStoreCode();
                boolean isEmpty1 = storeCode1 == null || storeCode1.trim().isEmpty();
                boolean bl = isEmpty2 = storeCode2 == null || storeCode2.trim().isEmpty();
                if (isEmpty1 && !isEmpty2) {
                    return 1;
                }
                if (!isEmpty1 && isEmpty2) {
                    return -1;
                }
                return -1;
            }
        });
        this.scpDemandSetRepo.saveAll(scpDemandSetDOS);
        for (n = 0; n < times; ++n) {
            String storeDemandCode = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("BKST", new ArrayList<String>());
            this.saveDemandSet(demandDate.atStartOfDay(), storeDemandCode, ScpUdcEnum.DEMAND_SET_TYPE_0, "\u95e8\u5e97\u8ba2\u8d27\u96c6");
        }
        for (n = 0; n < times; ++n) {
            String whDemandCode = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("BKWH", new ArrayList<String>());
            this.saveDemandSet(demandDate.atStartOfDay(), whDemandCode, ScpUdcEnum.DEMAND_SET_TYPE_1, "\u4ed3\u5e93\u8ba2\u8d27\u96c6");
        }
    }

    private void saveDemandSet(LocalDateTime demandDate, String demandCode, ScpUdcEnum demandType, String demandPrefix) {
        ScpDemandSetSaveVO demandSetSaveVO = new ScpDemandSetSaveVO();
        demandSetSaveVO.setDemandCode(demandCode);
        demandSetSaveVO.setType(demandType.getValueCode());
        demandSetSaveVO.setDemandName(demandPrefix + this.convertDate(demandDate) + demandCode.substring(demandCode.length() - 3));
        demandSetSaveVO.setDemandDate(demandDate);
        demandSetSaveVO.setCreateType(UdcEnum.SCP_ORDER_SET_CREATE_TYPE_01.getValueCode());
        if (ScpUdcEnum.DEMAND_SET_TYPE_0.equals((Object)demandType)) {
            demandSetSaveVO.setDocType("all");
            demandSetSaveVO.setStoreName("all");
            demandSetSaveVO.setStoreCode("all");
            demandSetSaveVO.setRegionCode("all");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        demandSetSaveVO.setExpireTime(LocalDateTime.of(demandDate.toLocalDate(), LocalTime.parse("16:00:00", formatter)));
        this.scpDemandSetDomainService.saveDemandSet(demandSetSaveVO);
    }

    private String convertDate(LocalDateTime demandDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u53f7");
        return demandDate.format(formatter);
    }

    public ScpDemandSetJobServiceImpl(RmiSysUserRpcService rmiSysUserRpcService, ScpDemandSetDomainService scpDemandSetDomainService, ScpStoreDemandCalendarService scpStoreDemandCalendarService, ScpOrderTemplateService orderTemplateService, ScpOrderTemplateRepo scpOrderTemplateRepo, ScpDemandSetRepo scpDemandSetRepo, SysSettingService sysSettingService) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.scpDemandSetDomainService = scpDemandSetDomainService;
        this.scpStoreDemandCalendarService = scpStoreDemandCalendarService;
        this.orderTemplateService = orderTemplateService;
        this.scpOrderTemplateRepo = scpOrderTemplateRepo;
        this.scpDemandSetRepo = scpDemandSetRepo;
        this.sysSettingService = sysSettingService;
    }
}

