package com.elitesland.yst.seata.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "StorageSaveVo", description = "保存库存--仅供测试使用")
public class StorageSaveVo implements Serializable {

    private static final long serialVersionUID = -22172561917267390L;

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("库存状态")
    String status;

    @ApiModelProperty("商品编号")
    String itemCode;

    @ApiModelProperty("商品名称")
    String itemName;

    @ApiModelProperty("商品价格")
    String itemPrice;

    @ApiModelProperty("数量")
    Double qty;

    @ApiModelProperty("分库字段")
    Integer dbId;
}
