/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.commons.db;

import cn.hutool.core.util.IdUtil;
import com.elitesland.commons.annotations.Table;
import com.elitesland.commons.db.BaseEntity;
import com.elitesland.commons.db.BaseQuery;
import com.elitesland.commons.db.Where;
import com.elitesland.commons.enums.DBType;
import com.elitesland.commons.utils.EntityUtils;
import com.elitesland.commons.utils.GenericsUtils;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.commons.utils.SqlUtils;
import com.elitesland.workflow.exception.WorkflowException;
import com.elitesland.workflow.utils.WorkflowUtils;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class BaseDao<T extends BaseEntity> {
    private static final Logger log = LoggerFactory.getLogger(BaseDao.class);
    protected final String QUERY_WHERE_SQL = "#QUERY_WHERE_SQL#";
    protected Class<T> entityClazz = GenericsUtils.getGenerics(this.getClass());
    protected String tableName;

    public BaseDao() {
        if (!this.entityClazz.isAnnotationPresent(Table.class)) {
            throw new RuntimeException("\u5b9e\u4f53[" + this.entityClazz.getName() + "]\u672a\u914d\u7f6e@Table");
        }
        this.tableName = this.entityClazz.getAnnotation(Table.class).name();
    }

    public long save(T entity) {
        return this.save(entity, null);
    }

    public long save(T entity, List<String> fieldNames) {
        if (((BaseEntity)entity).getId() == null) {
            this.add(entity);
        } else {
            this.updateById(entity, fieldNames);
        }
        return ((BaseEntity)entity).getId();
    }

    public long add(T entity) {
        List<String> fieldNames = EntityUtils.getNotNullFieldNames(entity, new String[0]);
        if (SpringUtils.getDBType().equals((Object)DBType.ORACLE)) {
            fieldNames.add(0, "id");
            ((BaseEntity)entity).setId(IdUtil.getSnowflakeNextId());
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            placeholders.add("?");
        }
        Object[] values = EntityUtils.getFieldValues(entity, fieldNames);
        String sql = "insert into " + this.tableName + "(" + StringUtils.join(fieldNames, (String)",") + ")values(" + StringUtils.join(placeholders, (String)", ") + ") ";
        log.info("\u65b0\u589e\u5b9e\u4f53sql:{}", (Object)sql);
        log.info("\u53c2\u6570:{}", Arrays.stream(values).collect(Collectors.toList()));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        SpringUtils.getJdbcTemplate().update(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql, 1);
            for (int i = 0; i < values.length; ++i) {
                ps.setObject(i + 1, values[i]);
            }
            return ps;
        }, (KeyHolder)keyHolder);
        if (!SpringUtils.getDBType().equals((Object)DBType.ORACLE)) {
            ((BaseEntity)entity).setId(keyHolder.getKey().longValue());
        }
        return ((BaseEntity)entity).getId();
    }

    public void updateById(T entity, List<String> fieldNames) {
        if (CollectionUtils.isEmpty(fieldNames)) {
            fieldNames = EntityUtils.getFieldNames(this.entityClazz, "id", "tenantId");
        }
        String sql = "update " + this.tableName + " set " + StringUtils.join(fieldNames, (String)"=?,") + "=? where id=?";
        log.info("\u4fee\u6539\u5b9e\u4f53sql:{}", (Object)sql);
        fieldNames.add("id");
        int row = SpringUtils.getJdbcTemplate().update(sql, EntityUtils.getFieldValues(entity, fieldNames));
        if (row != 1) {
            throw new RuntimeException("\u6ca1\u6709\u66f4\u65b0\u4e00\u6761\u6570\u636e");
        }
    }

    public long queryCount(String sql, BaseQuery query) {
        Where where = query.getWhere();
        sql = sql.replace("#QUERY_WHERE_SQL#", where.getSql());
        sql = WorkflowUtils.handUserTable(sql);
        return (Long)SpringUtils.getJdbcTemplate().queryForObject(sql, Long.class, where.getValues().toArray());
    }

    public <R> List<R> queryList(String sql, BaseQuery query, Class<R> returnType) {
        Where where = query.getWhere();
        sql = ((String)sql).replace("#QUERY_WHERE_SQL#", where.getSql());
        sql = (String)sql + query.getSortSql();
        sql = SqlUtils.handPage((String)sql, query);
        sql = WorkflowUtils.handUserTable((String)sql);
        System.out.println((String)sql);
        return SpringUtils.getJdbcTemplate().query((String)sql, (RowMapper)new BeanPropertyRowMapper(returnType), where.getValues().toArray());
    }

    public long queryCount(BaseQuery query) {
        String sql = "select count(1) from " + this.tableName + " where #QUERY_WHERE_SQL#";
        return this.queryCount(sql, query);
    }

    public T queryById(long id) {
        String sql = "select * from " + this.tableName + " where id=?";
        return (T)((BaseEntity)SpringUtils.getJdbcTemplate().queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(this.entityClazz), new Object[]{id}));
    }

    public T query(String fieldName, Object fieldValue) {
        String tenantId = WorkflowUtils.getTenantId();
        String sql = "select * from " + this.tableName + " t where t." + fieldName + "=? and t.tenantId=?";
        return (T)((BaseEntity)SpringUtils.getJdbcTemplate().queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(this.entityClazz), new Object[]{fieldValue, tenantId}));
    }

    public List<T> queryList(String fieldName, Object fieldValue) {
        String tenantId = WorkflowUtils.getTenantId();
        String sql = "select * from " + this.tableName + " t where t." + fieldName + "=? and t.tenantId=?";
        return SpringUtils.getJdbcTemplate().query(sql, (RowMapper)new BeanPropertyRowMapper(this.entityClazz), new Object[]{fieldValue, tenantId});
    }

    public void deleteByIds(List<Long> ids) {
        String sql = "delete from " + this.tableName + " where id in (:ids)";
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("ids", ids);
        SpringUtils.getNamedParameterJdbcTemplate().update(sql, params);
    }

    public void delete(String fieldName, Object fieldValue) {
        String sql = "delete from " + this.tableName + " where " + fieldName + " = :fieldValue";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fieldValue", fieldValue);
        SpringUtils.getNamedParameterJdbcTemplate().update(sql, params);
    }

    public boolean exist(Long id, String fieldName, String fieldValue) {
        String tenantId = WorkflowUtils.getTenantId();
        String sql = null;
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = "select count(1) from " + this.tableName + " where `" + fieldName + "`=:" + fieldName + " and tenantId=:tenantId " + (id != null ? " and id!=:id " : "");
                break;
            }
            case ORACLE: {
                sql = "select count(1) from " + this.tableName + " where " + fieldName + "=:" + fieldName + " and tenantId=:tenantId " + (id != null ? " and id!=:id " : "");
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(fieldName, fieldValue);
        paramMap.put("tenantId", tenantId);
        if (id != null) {
            paramMap.put("id", id);
        }
        return (Long)SpringUtils.getNamedParameterJdbcTemplate().queryForObject(sql, paramMap, Long.class) >= 1L;
    }
}

