/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.commons.db;

import com.elitesland.commons.annotations.SearchField;
import com.elitesland.commons.db.Where;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseQuery {
    private static final Logger log = LoggerFactory.getLogger(BaseQuery.class);
    private int current = 1;
    private int pageSize = 20;
    private String sort;
    private boolean isPaging = true;

    public String getSortSql() {
        if (StringUtils.isBlank((CharSequence)this.sort)) {
            return "";
        }
        return " ORDER BY " + this.sort;
    }

    public void setCurrent(int current) {
        this.current = current;
        if (current < 1) {
            this.current = 1;
        }
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize < 1) {
            this.pageSize = 20;
        }
    }

    public void setSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize < 1) {
            this.pageSize = 20;
        }
    }

    public String getLimitSql() {
        if (this.isPaging()) {
            return " limit " + (this.current - 1) * this.pageSize + " , " + this.pageSize;
        }
        return "";
    }

    public String getLimitSqlOracle() {
        int start = (this.current - 1) * this.pageSize + 1;
        return " between " + start + " and " + (start + this.pageSize - 1);
    }

    public Where getWhere() {
        Where where = new Where();
        List fieldList = FieldUtils.getFieldsListWithAnnotation(this.getClass(), SearchField.class);
        for (Field field : fieldList) {
            SearchField searchField = field.getAnnotation(SearchField.class);
            Object value = null;
            try {
                value = PropertyUtils.getProperty((Object)this, (String)field.getName());
            }
            catch (Exception e) {
                log.error("\u7ec4\u88c5\u5206\u9875\u67e5\u8be2SQL\u65f6\u62a5\u9519:{}", (Throwable)e);
            }
            if (value == null || !StringUtils.isNotBlank((CharSequence)value.toString())) continue;
            if (searchField.value().toLowerCase().contains(" like ")) {
                value = "%" + value.toString().trim() + "%";
            }
            where.getValues().add(value);
            where.getSqls().add(searchField.value());
        }
        return where;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getSort() {
        return this.sort;
    }

    public boolean isPaging() {
        return this.isPaging;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setPaging(boolean isPaging) {
        this.isPaging = isPaging;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseQuery)) {
            return false;
        }
        BaseQuery other = (BaseQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.isPaging() != other.isPaging()) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrent();
        result = result * 59 + this.getPageSize();
        result = result * 59 + (this.isPaging() ? 79 : 97);
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        return result;
    }

    public String toString() {
        return "BaseQuery(current=" + this.getCurrent() + ", pageSize=" + this.getPageSize() + ", sort=" + this.getSort() + ", isPaging=" + this.isPaging() + ")";
    }
}

