/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.commons.enums;

public enum ApiCode {
    SUCCESS(200, "\u64cd\u4f5c\u6210\u529f"),
    UNAUTHORIZED(401, "\u8bf7\u5148\u767b\u5f55"),
    NOT_PERMISSION(403, "\u6ca1\u6709\u6743\u9650"),
    NOT_FOUND(404, "\u4f60\u8bf7\u6c42\u7684\u8d44\u6e90\u4e0d\u5b58\u5728"),
    FAIL(500, "\u64cd\u4f5c\u5931\u8d25"),
    LOGIN_EXCEPTION(4000, "\u767b\u5f55\u5931\u8d25"),
    SYSTEM_EXCEPTION(5000, "\u7cfb\u7edf\u5f02\u5e38!"),
    PARAMETER_EXCEPTION(5001, "\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38"),
    PARAMETER_PARSE_EXCEPTION(5002, "\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38"),
    HTTP_MEDIA_TYPE_EXCEPTION(5003, "HTTP Media \u7c7b\u578b\u5f02\u5e38"),
    SPRING_BOOT_PLUS_EXCEPTION(5100, "\u7cfb\u7edf\u5904\u7406\u5f02\u5e38"),
    BUSINESS_EXCEPTION(5101, "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38"),
    DAO_EXCEPTION(5102, "\u6570\u636e\u5e93\u5904\u7406\u5f02\u5e38"),
    VERIFICATION_CODE_EXCEPTION(5103, "\u9a8c\u8bc1\u7801\u6821\u9a8c\u5f02\u5e38"),
    AUTHENTICATION_EXCEPTION(5104, "\u767b\u5f55\u6388\u6743\u5f02\u5e38"),
    UNAUTHENTICATED_EXCEPTION(5105, "\u8eab\u4efd\u8ba4\u8bc1\u4e0d\u6b63\u786e"),
    UNAUTHORIZED_EXCEPTION(5106, "\u6ca1\u6709\u8bbf\u95ee\u6743\u9650"),
    UNAUTHORIZED_ANONYMOUS(5107, "\u533f\u540d\u7528\u6237\uff0c\u672a\u6388\u6743\u8bbf\u95ee"),
    NO_USER_FOUND_EXCEPTION(5108, "\u7528\u6237\u4fe1\u606f\u672a\u627e\u5230\uff0c\u7cfb\u7edf\u5f02\u5e38");

    private final int code;
    private final String msg;

    private ApiCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static ApiCode getApiCode(int code) {
        ApiCode[] ecs;
        for (ApiCode ec : ecs = ApiCode.values()) {
            if (ec.getCode() != code) continue;
            return ec;
        }
        return SUCCESS;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }
}

