/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.commons.utils;

import com.elitesland.commons.annotations.SqlIgnore;
import com.elitesland.commons.db.BaseEntity;
import com.elitesland.commons.enums.DBType;
import com.elitesland.commons.utils.SpringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityUtils {
    private static final Logger log = LoggerFactory.getLogger(EntityUtils.class);

    public static <T> List<String> getFieldNames(Class<T> entityClazz, String ... excludeFieldNames) {
        return FieldUtils.getAllFieldsList(entityClazz).stream().filter(field -> {
            if (field.getAnnotation(SqlIgnore.class) != null) {
                return false;
            }
            for (String excludeFieldName : excludeFieldNames) {
                if (!field.getName().equals(excludeFieldName)) continue;
                return false;
            }
            return true;
        }).map(field -> {
            if (SpringUtils.getDBType().equals((Object)DBType.MySQL)) {
                return "`" + field.getName() + "`";
            }
            return field.getName();
        }).collect(Collectors.toList());
    }

    public static List<String> getNotNullFieldNames(BaseEntity entity, String ... excludeFieldNames) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        FieldUtils.getAllFieldsList(entity.getClass()).stream().filter(field -> {
            if (field.getAnnotation(SqlIgnore.class) != null) {
                return false;
            }
            for (String excludeFieldName : excludeFieldNames) {
                if (!field.getName().equals(excludeFieldName)) continue;
                return false;
            }
            return true;
        }).forEach(field -> {
            try {
                Object fieldName = field.getName();
                Object value = PropertyUtils.getProperty((Object)entity, (String)fieldName);
                if (value != null) {
                    if (SpringUtils.getDBType().equals((Object)DBType.MySQL)) {
                        fieldName = "`" + (String)fieldName + "`";
                    }
                    fieldNames.add((String)fieldName);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5b9e\u4f53\u5bf9\u8c61\u7684\u5b57\u6bb5\u503c\uff1a{}", (Throwable)e);
            }
        });
        return fieldNames;
    }

    public static Object[] getFieldValues(BaseEntity entity, List<String> fieldNames) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (String fieldName : fieldNames) {
            try {
                fieldName = fieldName.replace("`", "");
                Object value = PropertyUtils.getProperty((Object)entity, (String)fieldName);
                if (value != null) {
                    if (value instanceof Enum) {
                        results.add(value.toString());
                        continue;
                    }
                    if (value instanceof List) {
                        results.add(StringUtils.join((Iterable)((List)value), (String)","));
                        continue;
                    }
                    results.add(value);
                    continue;
                }
                results.add(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u83b7\u53d6\u5b9e\u4f53\u5bf9\u8c61\u7684\u5b57\u6bb5\u503c\uff1a{}", (Throwable)e);
            }
        }
        return results.toArray();
    }
}

