/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.commons.utils;

import com.elitesland.commons.enums.ApiCode;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.exception.WorkflowException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.apache.commons.lang3.StringUtils;

public class JwtUtils {
    private static final String AUTHORIZATION = "Authorization";
    private static final String AUTHORIZATION_PREFIX = "bearer ";
    private static final String USER_ID_V2 = "yst_ui";
    private static final String TENANT_ID_V2 = "yst_ti";

    public static PublicKey getPublicKeyV2() {
        PublicKey publicKey;
        block8: {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("yst-config.jks");
            try {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(inputStream, "elitesland516".toCharArray());
                Certificate cert = keyStore.getCertificate("yst-config");
                publicKey = cert.getPublicKey();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new WorkflowException(ApiCode.UNAUTHENTICATED_EXCEPTION.getCode(), "\u83b7\u53d6\u516c\u94a5\u5931\u8d25");
                }
            }
            inputStream.close();
        }
        return publicKey;
    }

    private static String getToken() {
        String header = SpringUtils.getRequest().getHeader(AUTHORIZATION);
        if (StringUtils.isBlank((CharSequence)header)) {
            throw new WorkflowException(ApiCode.UNAUTHENTICATED_EXCEPTION.getCode(), "\u8bf7\u767b\u5f55");
        }
        if (!header.toLowerCase().startsWith(AUTHORIZATION_PREFIX)) {
            throw new WorkflowException(ApiCode.UNAUTHENTICATED_EXCEPTION.getCode(), "\u4ee4\u724c\u683c\u5f0f\u4e0d\u6b63\u786e(\u975ebearer\u5f00\u5934)");
        }
        String token = StringUtils.substringAfter((String)header, (String)" ");
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new WorkflowException(ApiCode.UNAUTHENTICATED_EXCEPTION.getCode(), "\u4ee4\u724c\u683c\u5f0f\u4e0d\u6b63\u786e(bearer\u540e\u6ca1\u5185\u5bb9)");
        }
        return token;
    }

    public static String getUserId() {
        String token = JwtUtils.getToken();
        System.out.println("token:" + token);
        Claims body = (Claims)Jwts.parser().setSigningKey((Key)JwtUtils.getPublicKeyV2()).parseClaimsJws(token).getBody();
        if (body.get((Object)USER_ID_V2) == null) {
            throw new WorkflowException(ApiCode.UNAUTHENTICATED_EXCEPTION.getCode(), "\u4ee4\u724c\u683c\u5f0f\u4e0d\u6b63\u786e,\u65e0\u7528\u6237ID\u4fe1\u606f");
        }
        return body.get((Object)USER_ID_V2).toString();
    }

    public static String getTenantId() {
        Claims body = (Claims)Jwts.parser().setSigningKey((Key)JwtUtils.getPublicKeyV2()).parseClaimsJws(JwtUtils.getToken()).getBody();
        if (body.get((Object)TENANT_ID_V2) == null) {
            System.out.println("\u6ca1\u6709\u83b7\u53d6\u8bf7\u6c42\u4e2d\u79df\u6237ID,\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a0,jwt\u4fe1\u606f:" + body);
            return "0";
        }
        return body.get((Object)TENANT_ID_V2).toString();
    }
}

