/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.commons.utils;

import com.elitesland.commons.enums.DBType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SpringUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtils.applicationContext = applicationContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)applicationContext.getBean(clazz);
    }

    public static Object getBean(String beanName) {
        return applicationContext.getBean(beanName);
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static String getUserAgent() {
        return SpringUtils.getRequest().getHeader("user-agent");
    }

    public static JdbcTemplate getJdbcTemplate() {
        return SpringUtils.getBean(JdbcTemplate.class);
    }

    public static NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return SpringUtils.getBean(NamedParameterJdbcTemplate.class);
    }

    public static void shutdown() {
        ((ConfigurableApplicationContext)applicationContext).close();
    }

    public static <T> T getValue(String key, Class<T> clazz) {
        return (T)SpringUtils.getBean(Environment.class).getProperty(key, clazz);
    }

    public static boolean hasTenant() {
        Boolean hasTenant = SpringUtils.getValue("workflow.hasTenant", Boolean.class);
        return hasTenant == null || hasTenant != false;
    }

    public static DBType getDBType() {
        DBType dbType = SpringUtils.getValue("workflow.DBType", DBType.class);
        return dbType == null ? DBType.MySQL : dbType;
    }

    public static String getSystemDBName() {
        String systemDBName = SpringUtils.getValue("workflow.SystemDBName", String.class);
        String character = SpringUtils.getDBType().equals((Object)DBType.MySQL) ? "`" : "\"";
        return StringUtils.isBlank((CharSequence)systemDBName) ? "" : character + systemDBName.trim() + character + ".";
    }

    public static boolean expression(String expression, Object variables) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return false;
        }
        if (variables == null) {
            return false;
        }
        Expression exp = new SpelExpressionParser().parseExpression(expression);
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable("var", variables);
        return (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
    }
}

