/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.commons.utils;

import com.elitesland.commons.db.BaseQuery;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.exception.WorkflowException;
import org.apache.commons.lang3.StringUtils;

public class SqlUtils {
    public static String CONCAT(String ... items) {
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                return "CONCAT(" + StringUtils.join((Object[])items, (String)",") + ")";
            }
            case ORACLE: {
                int length = items.length;
                Object sql = StringUtils.repeat((String)"CONCAT(", (int)(length - 1));
                for (int i = 1; i < length; ++i) {
                    sql = i == 1 ? (String)sql + items[0] + "," + items[1] + ")" : (String)sql + "," + items[i] + ")";
                }
                return sql;
            }
        }
        throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
    }

    public static String GROUP_CONCAT(String field) {
        return SqlUtils.GROUP_CONCAT(field, "','");
    }

    public static String GROUP_CONCAT(String field, String separator) {
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                return "GROUP_CONCAT(" + field + " SEPARATOR " + separator + ")";
            }
            case ORACLE: {
                return "LISTAGG(to_char(" + field + "), " + separator + ") WITHIN GROUP(ORDER BY " + field + ")";
            }
        }
        throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
    }

    public static String CONCAT_COMMA(String field) {
        return SqlUtils.CONCAT("','", field, "','");
    }

    public static String handPage(String sql, BaseQuery query) {
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = (String)sql + query.getLimitSql();
                break;
            }
            case ORACLE: {
                sql = ((String)sql).replaceFirst("select", "select rownum rn,");
                sql = "select * from (" + (String)sql + ") xxxxx where  xxxxx.rn " + query.getLimitSqlOracle();
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        return sql;
    }

    public static String limit1(String sql) {
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = (String)sql + " limit 1";
                break;
            }
            case ORACLE: {
                sql = "select * from (" + (String)sql + ") xxxxx where rownum=1";
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        return sql;
    }

    public static String getCurrentDate() {
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                return "CURRENT_DATE()";
            }
            case ORACLE: {
                return "current_date";
            }
        }
        throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
    }

    public static String getFieldAlias(String key) {
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                return "`" + key + "`";
            }
            case ORACLE: {
                return "\"" + key + "\"";
            }
        }
        throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
    }
}

