/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.config;

import com.elitesland.commons.utils.SpringUtils;
import io.seata.core.context.RootContext;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String xid;
        HttpHeaders headers = request.getHeaders();
        HttpServletRequest httpServletRequest = SpringUtils.getRequest();
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = httpServletRequest.getHeader(headerName);
                if (headerName.equalsIgnoreCase("Content-Length") || headerName.equalsIgnoreCase("Content-Type")) continue;
                headers.set(headerName, headerValue);
            }
        }
        if ((xid = RootContext.getXID()) != null && xid.length() > 0) {
            headers.set("TX_XID", xid);
        }
        return execution.execute(request, body);
    }
}

