/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.config;

import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.Constant;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.dao.ProcInstDao;
import com.elitesland.workflow.dao.WorkflowDao;
import com.elitesland.workflow.entity.TaskNodeConfig;
import com.elitesland.workflow.entity.TaskNodeConfigVariableCondition;
import com.elitesland.workflow.enums.AssigneeType;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.exception.WorkflowException;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import com.elitesland.workflow.service.TaskNodeConfigService;
import com.elitesland.workflow.utils.WorkflowUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowListener
extends AbstractFlowableEngineEventListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowListener.class);
    private final TaskService taskService;
    private final RuntimeService runtimeService;
    private final TaskNodeConfigService taskNodeConfigService;
    private final ProcInstDao procInstDao;
    private final WorkflowDao workflowDao;
    private final WorkflowCallBack workflowCallBack;

    protected void taskCreated(FlowableEngineEntityEvent event) {
        CommentInfo commentInfo;
        ProcInstStatus procInstStatus;
        String tenantId = WorkflowUtils.getTenantId();
        TaskEntity taskEntity = (TaskEntity)event.getEntity();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(taskEntity.getProcessInstanceId()).singleResult();
        String processDefinitionKey = WorkflowUtils.getProcessDefinitionKey(taskEntity.getProcessDefinitionId());
        String taskDefinitionKey = taskEntity.getTaskDefinitionKey();
        String executionId = taskEntity.getExecutionId();
        String businessKey = processInstance.getBusinessKey();
        if (Constant.FIRST_TASK_DEF_KEY.equals(taskDefinitionKey) && (procInstStatus = this.procInstDao.queryStatus(taskEntity.getProcessInstanceId())) != null && (ProcInstStatus.NOTSUBMIT == procInstStatus || ProcInstStatus.REJECTED == procInstStatus)) {
            commentInfo = this.workflowDao.queryLastComment(taskEntity.getProcessInstanceId());
            this.workflowCallBack.processStatusChange(ProcessStatusChangePayload.of((String)tenantId, (String)processDefinitionKey, (ProcInstStatus)procInstStatus, (String)businessKey, (CommentInfo)commentInfo));
        }
        HashSet<String> taskAssignees = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)taskEntity.getAssignee())) {
            TaskNodeConfig taskNodeConfig = this.taskNodeConfigService.queryByDefKey(processDefinitionKey, taskDefinitionKey);
            switch (AssigneeType.valueOf(taskNodeConfig.getAssigneeType())) {
                case DYNAMIC: {
                    ArrayList userIds = this.workflowCallBack.taskAssignee(TaskAssigneePayload.of((String)tenantId, (String)processDefinitionKey, (String)taskDefinitionKey, (String)businessKey, (String)taskNodeConfig.getCustomParams()));
                    this.setAssignee(taskEntity.getId(), userIds);
                    if (CollectionUtils.isNotEmpty((Collection)userIds)) {
                        taskAssignees.addAll(userIds);
                    }
                    log.info("\u4efb\u52a1\u8282\u70b9:{},\u52a8\u6001\u6307\u5b9a\u7528\u6237:{}", (Object)taskEntity.getId(), (Object)userIds);
                    break;
                }
                case VARIABLE: {
                    Object variable = this.runtimeService.getVariable(executionId, taskDefinitionKey);
                    if (variable == null) {
                        throw new WorkflowException("\u4f7f\u7528\u6d41\u7a0b\u53d8\u91cf\u8bbe\u7f6e\u4efb\u52a1\u5904\u7406\u4eba\u65f6\uff0c\u672a\u627e\u5230\u6d41\u7a0b\u53d8\u91cf");
                    }
                    List userIds = (List)variable;
                    this.setAssignee(taskEntity.getId(), userIds);
                    if (CollectionUtils.isNotEmpty((Collection)userIds)) {
                        taskAssignees.addAll(userIds);
                    }
                    log.info("\u4efb\u52a1\u8282\u70b9:{},\u4f7f\u7528\u6d41\u7a0b\u53d8\u91cf\u76f4\u63a5\u6307\u5b9a\u4eba:{}", (Object)taskEntity.getId(), (Object)userIds);
                    break;
                }
                case VARIABLE2: {
                    Map variables = this.runtimeService.getVariables(executionId);
                    ArrayList<String> userIds = new ArrayList<String>();
                    List<TaskNodeConfigVariableCondition> variableConditionList = taskNodeConfig.getVariableConditionList();
                    if (CollectionUtils.isNotEmpty(variableConditionList)) {
                        for (TaskNodeConfigVariableCondition taskNodeConfigVariableCondition : variableConditionList) {
                            if (!SpringUtils.expression(taskNodeConfigVariableCondition.getCondition(), variables)) continue;
                            userIds.addAll(taskNodeConfigVariableCondition.getAssigneeUserIds());
                        }
                    }
                    this.setAssignee(taskEntity.getId(), userIds);
                    if (CollectionUtils.isNotEmpty(userIds)) {
                        taskAssignees.addAll(userIds);
                    }
                    log.info("\u4efb\u52a1\u8282\u70b9:{},\u4f7f\u7528\u6d41\u7a0b\u53d8\u91cf\u4f5c\u4e3a\u6761\u4ef6\u6307\u5b9a\u4eba:{}", (Object)taskEntity.getId(), userIds);
                    break;
                }
                case FIXED_USERS: {
                    List<String> userIds = taskNodeConfig.getAssigneeUserIds();
                    this.setAssignee(taskEntity.getId(), userIds);
                    if (CollectionUtils.isNotEmpty(userIds)) {
                        taskAssignees.addAll(userIds);
                    }
                    log.info("\u4efb\u52a1\u8282\u70b9:{},\u56fa\u5b9a\u7528\u6237:{}", (Object)taskEntity.getId(), userIds);
                    break;
                }
                case START_USER: {
                    ArrayList<String> userIds = new ArrayList<String>();
                    userIds.add(processInstance.getStartUserId());
                    this.setAssignee(taskEntity.getId(), userIds);
                    if (CollectionUtils.isNotEmpty(userIds)) {
                        taskAssignees.addAll(userIds);
                    }
                    log.info("\u4efb\u52a1\u8282\u70b9:{},\u53d1\u8d77\u4eba:{}", (Object)taskEntity.getId(), userIds);
                    break;
                }
            }
        }
        commentInfo = this.workflowDao.queryLastComment(taskEntity.getProcessInstanceId());
        this.workflowCallBack.taskCreated(TaskCreatedPayload.of((String)tenantId, (String)processDefinitionKey, (String)taskDefinitionKey, (String)taskEntity.getName(), (String)businessKey, taskAssignees, (CommentInfo)commentInfo));
    }

    protected void taskCompleted(FlowableEngineEntityEvent event) {
        ProcInstStatus procInstStatus;
        String tenantId = WorkflowUtils.getTenantId();
        TaskEntity taskEntity = (TaskEntity)event.getEntity();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(taskEntity.getProcessInstanceId()).singleResult();
        String processDefinitionKey = WorkflowUtils.getProcessDefinitionKey(taskEntity.getProcessDefinitionId());
        this.workflowCallBack.taskCompleted(TaskCompletedPayload.of((String)tenantId, (String)processDefinitionKey, (String)taskEntity.getTaskDefinitionKey(), (String)taskEntity.getName(), (String)processInstance.getBusinessKey(), (String)taskEntity.getAssignee()));
        if (Constant.FIRST_TASK_DEF_KEY.equals(taskEntity.getTaskDefinitionKey()) && (procInstStatus = this.procInstDao.queryStatus(taskEntity.getProcessInstanceId())) != null && (ProcInstStatus.NOTSUBMIT == procInstStatus || ProcInstStatus.REJECTED == procInstStatus)) {
            this.procInstDao.updateStatus(taskEntity.getProcessInstanceId(), ProcInstStatus.APPROVING);
            String businessKey = processInstance.getBusinessKey();
            CommentInfo commentInfo = this.workflowDao.queryLastComment(taskEntity.getProcessInstanceId());
            this.workflowCallBack.processStatusChange(ProcessStatusChangePayload.of((String)tenantId, (String)processDefinitionKey, (ProcInstStatus)ProcInstStatus.APPROVING, (String)businessKey, (CommentInfo)commentInfo));
        }
    }

    protected void processCompleted(FlowableEngineEntityEvent event) {
        String tenantId = WorkflowUtils.getTenantId();
        ExecutionEntityImpl entity = (ExecutionEntityImpl)event.getEntity();
        ProcInstStatus procInstStatus = this.procInstDao.queryStatus(event.getProcessInstanceId());
        if (procInstStatus == ProcInstStatus.APPROVING) {
            procInstStatus = ProcInstStatus.APPROVED;
            this.procInstDao.updateStatus(event.getProcessInstanceId(), procInstStatus);
        }
        String processDefinitionKey = WorkflowUtils.getProcessDefinitionKey(event.getProcessDefinitionId());
        String businessKey = entity.getBusinessKey();
        CommentInfo commentInfo = this.workflowDao.queryLastComment(event.getProcessInstanceId());
        this.workflowCallBack.processStatusChange(ProcessStatusChangePayload.of((String)tenantId, (String)processDefinitionKey, (ProcInstStatus)procInstStatus, (String)businessKey, (CommentInfo)commentInfo));
    }

    private void setAssignee(String taskId, List<String> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            HashSet<String> userIds = new HashSet<String>(list);
            userIds.remove(null);
            if (userIds.size() > 0) {
                if (userIds.size() == 1) {
                    this.taskService.setAssignee(taskId, (String)userIds.iterator().next());
                } else {
                    userIds.forEach(userId -> this.taskService.addCandidateUser(taskId, userId));
                }
            }
        }
    }

    public WorkflowListener(TaskService taskService, RuntimeService runtimeService, TaskNodeConfigService taskNodeConfigService, ProcInstDao procInstDao, WorkflowDao workflowDao, WorkflowCallBack workflowCallBack) {
        this.taskService = taskService;
        this.runtimeService = runtimeService;
        this.taskNodeConfigService = taskNodeConfigService;
        this.procInstDao = procInstDao;
        this.workflowDao = workflowDao;
        this.workflowCallBack = workflowCallBack;
    }
}

