/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.controller;

import com.elitesland.commons.utils.JwtUtils;
import com.elitesland.commons.web.Result;
import com.elitesland.workflow.controller.AgentQuery;
import com.elitesland.workflow.dao.AgentDao;
import com.elitesland.workflow.domain.AgentPayload;
import com.elitesland.workflow.utils.WorkflowUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5f85\u529e\u4eba", tags={"\u5f85\u529e\u4eba"})
@RestController
@RequestMapping(value={"/workflow/api/agent"})
public class AgentController {
    private final AgentDao agentDao;

    @ApiOperation(value="\u6d41\u7a0b\u7c7b\u522b\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/search"})
    public Result query(@RequestBody AgentQuery query) {
        String currentUserId = JwtUtils.getUserId();
        query.setCurrentUserId(currentUserId);
        query.setTenantId(WorkflowUtils.getTenantId());
        return Result.success(this.agentDao.queryList(query), this.agentDao.queryCount(query));
    }

    @ApiOperation(value="\u4fdd\u5b58\u4ee3\u529e\u4eba")
    @PostMapping(value={""})
    public Result save(@RequestBody @Validated AgentPayload agentPayload) {
        agentPayload.setUserId(Long.parseLong(JwtUtils.getUserId()));
        agentPayload.setTenantId(WorkflowUtils.getTenantId());
        this.agentDao.save(agentPayload);
        return Result.success();
    }

    public AgentController(AgentDao agentDao) {
        this.agentDao = agentDao;
    }
}

