/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.controller;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.commons.web.Result;
import com.elitesland.workflow.controller.CategoryQuery;
import com.elitesland.workflow.dao.CategoryDao;
import com.elitesland.workflow.entity.Category;
import com.elitesland.workflow.service.CategoryService;
import com.elitesland.workflow.utils.WorkflowUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6d41\u7a0b\u7c7b\u522b", tags={"\u6d41\u7a0b\u7c7b\u522b"})
@RestController
@RequestMapping(value={"/workflow/api/category"})
public class CategoryController {
    private final CategoryDao categoryDao;
    private final CategoryService categoryService;

    @ApiOperation(value="\u6d41\u7a0b\u7c7b\u522b\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/search"})
    public Result query(@RequestBody CategoryQuery query) {
        query.setTenantId(WorkflowUtils.getTenantId());
        return Result.success(this.categoryDao.queryList(query), this.categoryDao.queryCount(query));
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u6d41\u7a0b\u7c7b\u522b")
    @GetMapping(value={"/{id}"})
    public Result query(@PathVariable(value="id") long id) {
        return Result.success(this.categoryDao.queryById(id));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u5b9e\u4f8b")
    @PostMapping(value={""})
    public Result save(@RequestBody Category entity) {
        entity.setTenantId(WorkflowUtils.getTenantId());
        return Result.success(this.categoryDao.save(entity));
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u7c7b\u522b")
    @DeleteMapping(value={"/{id}"})
    public Result delete(@PathVariable(value="id") long id) {
        this.categoryService.deleteByIds(CollUtil.newArrayList((Object[])new Long[]{id}));
        return Result.success();
    }

    public CategoryController(CategoryDao categoryDao, CategoryService categoryService) {
        this.categoryDao = categoryDao;
        this.categoryService = categoryService;
    }
}

