/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.controller;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.commons.web.Result;
import com.elitesland.workflow.controller.ProcDefQuery;
import com.elitesland.workflow.dao.ProcDefDao;
import com.elitesland.workflow.entity.ProcDef;
import com.elitesland.workflow.service.ProcDefService;
import com.elitesland.workflow.utils.WorkflowUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6d41\u7a0b\u5b9a\u4e49", tags={"\u6d41\u7a0b\u5b9a\u4e49"})
@RestController
@RequestMapping(value={"/workflow/api/procDef"})
public class ProcDefController {
    private final ProcDefDao procDefDao;
    private final ProcDefService procDefService;

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/search"})
    public Result query(@RequestBody ProcDefQuery query) {
        query.setTenantId(WorkflowUtils.getTenantId());
        return Result.success(this.procDefDao.queryList(query), this.procDefDao.queryCount(query));
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49")
    @GetMapping(value={"/{id}"})
    public Result query(@PathVariable(value="id") long id) {
        return Result.success(this.procDefDao.queryById(id));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49")
    @PostMapping(value={""})
    public Result save(@RequestBody ProcDef entity) {
        entity.setTenantId(WorkflowUtils.getTenantId());
        return Result.success(this.procDefService.save(entity));
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49")
    @DeleteMapping(value={"/{id}"})
    public Result delete(@PathVariable(value="id") long id) {
        this.procDefService.deleteByIds(CollUtil.newArrayList((Object[])new Long[]{id}));
        return Result.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u56fexml")
    @GetMapping(value={"/xml"})
    public Result xml(long id) {
        return Result.success(this.procDefDao.queryXmlById(id));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u56fexml")
    @PostMapping(value={"/xml"})
    public Result saveXml(@RequestBody ProcDef entity) {
        return Result.success(this.procDefService.saveXml(entity));
    }

    @ApiOperation(value="\u6240\u6709\u6d41\u7a0b\u6d41\u7a0b\u5b9e\u4f8b")
    @GetMapping(value={"/procDefs"})
    public Result procDefs() {
        return Result.success(this.procDefDao.procDefs());
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6d41\u7a0b\u5b9a\u4e49\u662f\u5426\u652f\u6301\u4f5c\u5e9f")
    @PostMapping(value={"/supportInvalid"})
    public Result supportInvalid(long id, boolean supportInvalid) {
        this.procDefDao.supportInvalid(id, supportInvalid);
        return Result.success();
    }

    public ProcDefController(ProcDefDao procDefDao, ProcDefService procDefService) {
        this.procDefDao = procDefDao;
        this.procDefService = procDefService;
    }
}

