/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.controller;

import com.elitesland.commons.utils.JwtUtils;
import com.elitesland.commons.web.Result;
import com.elitesland.workflow.dao.TaskNodeConfigDao;
import com.elitesland.workflow.dao.TaskNodeConfigVariableConditionDao;
import com.elitesland.workflow.entity.TaskNodeConfig;
import com.elitesland.workflow.entity.TaskNodeConfigVariableCondition;
import com.elitesland.workflow.exception.WorkflowException;
import com.elitesland.workflow.service.TaskNodeConfigService;
import com.elitesland.workflow.utils.WorkflowUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u4efb\u52a1\u8282\u70b9\u914d\u7f6e", tags={"\u4efb\u52a1\u8282\u70b9\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/workflow/api/taskNodeConfig"})
public class TaskNodeConfigController {
    private final TaskNodeConfigDao taskNodeConfigDao;
    private final TaskNodeConfigVariableConditionDao taskNodeConfigVariableConditionDao;
    private final TaskNodeConfigService taskNodeConfigService;

    @ApiOperation(value="\u8bfb\u53d6\u4efb\u52a1\u8282\u70b9\u914d\u7f6e")
    @GetMapping(value={""})
    public Result queryByDefKey(String procDefKey, String taskDefId) {
        return Result.success(this.taskNodeConfigService.queryByDefKey(procDefKey, taskDefId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u4efb\u52a1\u8282\u70b9\u914d\u7f6e(\u5b9e\u65f6)")
    @PostMapping(value={""})
    @Transactional
    public Result save(@RequestBody @Validated TaskNodeConfig taskNodeConfig) {
        if (taskNodeConfig.getId() == null) {
            throw new WorkflowException("\u4fdd\u5b58\u5931\u8d25,\u8bf7\u5237\u65b0\u9875\u9762\u518d\u8bd5");
        }
        String tenantId = WorkflowUtils.getTenantId();
        taskNodeConfig.setTenantId(tenantId);
        this.taskNodeConfigDao.save(taskNodeConfig);
        this.taskNodeConfigVariableConditionDao.delete("configId", taskNodeConfig.getId());
        if (CollectionUtils.isNotEmpty(taskNodeConfig.getVariableConditionList())) {
            for (TaskNodeConfigVariableCondition taskNodeConfigVariableCondition : taskNodeConfig.getVariableConditionList()) {
                taskNodeConfigVariableCondition.setConfigId(taskNodeConfig.getId());
                taskNodeConfigVariableCondition.setTenantId(tenantId);
                this.taskNodeConfigVariableConditionDao.add(taskNodeConfigVariableCondition);
            }
        }
        return Result.success(taskNodeConfig.getId());
    }

    @ApiOperation(value="\u8bfb\u53d6\u4efb\u52a1\u8282\u70b9\u914d\u7f6e")
    @GetMapping(value={"/queryByProcInstId"})
    public Result queryByBusiness(String processInstanceId) {
        String currentUserId = JwtUtils.getUserId();
        return Result.success(this.taskNodeConfigService.queryByProcInstId(processInstanceId, currentUserId));
    }

    public TaskNodeConfigController(TaskNodeConfigDao taskNodeConfigDao, TaskNodeConfigVariableConditionDao taskNodeConfigVariableConditionDao, TaskNodeConfigService taskNodeConfigService) {
        this.taskNodeConfigDao = taskNodeConfigDao;
        this.taskNodeConfigVariableConditionDao = taskNodeConfigVariableConditionDao;
        this.taskNodeConfigService = taskNodeConfigService;
    }
}

