/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.controller;

import com.elitesland.commons.utils.JwtUtils;
import com.elitesland.commons.web.Result;
import com.elitesland.workflow.controller.WorkflowProcQuery;
import com.elitesland.workflow.controller.WorkflowTaskQuery;
import com.elitesland.workflow.dao.WorkflowDao;
import com.elitesland.workflow.domain.ProcessDefinitionHistory;
import com.elitesland.workflow.payload.ActivateProcDefPayLoad;
import com.elitesland.workflow.payload.ActivateProcInstPayload;
import com.elitesland.workflow.payload.AddSignPayLoad;
import com.elitesland.workflow.payload.BackPayLoad;
import com.elitesland.workflow.payload.ChangeTaskAssignessPayLoad;
import com.elitesland.workflow.payload.CompletePayLoad;
import com.elitesland.workflow.payload.DelegationPayload;
import com.elitesland.workflow.payload.InterruptProcInstPayLoad;
import com.elitesland.workflow.payload.InvalidProcInstPayload;
import com.elitesland.workflow.payload.TransferPayload;
import com.elitesland.workflow.payload.WithdrawPayLoad;
import com.elitesland.workflow.service.TaskNodeConfigService;
import com.elitesland.workflow.service.WorkflowServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5de5\u4f5c\u6d41", tags={"\u5de5\u4f5c\u6d41"})
@RestController
@RequestMapping(value={"/workflow/api"})
public class WorkflowController {
    private final WorkflowServiceImpl workflowServiceImpl;
    private final WorkflowDao workflowDao;
    private final TaskNodeConfigService taskNodeConfigService;

    @ApiOperation(value="\u90e8\u7f72\u6d41\u7a0b")
    @PostMapping(value={"/deploy/{id}"})
    public Result deploy(@PathVariable(value="id") long id) throws IOException {
        this.workflowServiceImpl.deploy(id);
        return Result.success();
    }

    @ApiOperation(value="\u6302\u8d77/\u6fc0\u6d3b (\u6d41\u7a0b\u5b9a\u4e49 , \u6d41\u7a0b\u5b9a\u4e49\u4e0b\u7684'\u6d41\u7a0b\u5b9e\u4f8b','\u4efb\u52a1\u5b9e\u4f8b'\u540c\u65f6\u6302\u8d77/\u6fc0\u6d3b)")
    @PostMapping(value={"/activateProcessDefinition"})
    public Result activateProcessDefinition(@RequestBody @Validated ActivateProcDefPayLoad activateProcDefPayLoad) {
        this.workflowServiceImpl.activateProcessDefinition(activateProcDefPayLoad);
        return Result.success();
    }

    @ApiOperation(value="\u6302\u8d77/\u6fc0\u6d3b(\u6d41\u7a0b\u5b9e\u4f8b , \u6d41\u7a0b\u5b9e\u4f8b\u4e0b\u7684'\u4efb\u52a1\u5b9e\u4f8b'\u540c\u65f6\u6302\u8d77/\u63a5\u6d3b)")
    @PostMapping(value={"/activateProcessInstance"})
    public Result activateProcessInstance(@RequestBody @Validated ActivateProcInstPayload activateProcInstPayload) {
        this.workflowServiceImpl.activateProcessInstance(activateProcInstPayload);
        return Result.success();
    }

    @ApiOperation(value="\u4e2d\u65ad\u6d41\u7a0b\u5b9e\u4f8b")
    @PostMapping(value={"/interruptProcessInstance"})
    public Result interruptProcessInstance(@RequestBody @Validated InterruptProcInstPayLoad interruptProcInstPayLoad) {
        this.workflowServiceImpl.interruptProcessInstance(interruptProcInstPayLoad);
        return Result.success();
    }

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5386\u53f2")
    @GetMapping(value={"/processDefinitionHistory/{processDefinitionKey}"})
    public Result processDefinitionHistory(@PathVariable String processDefinitionKey) {
        List<ProcessDefinitionHistory> processDefinitionHistories = this.workflowDao.processDefinitionHistory(processDefinitionKey);
        if (CollectionUtils.isNotEmpty(processDefinitionHistories)) {
            processDefinitionHistories.get(0).setLatestVersion(true);
        }
        return Result.success(processDefinitionHistories);
    }

    @ApiOperation(value="\u6d41\u7a0b\u56fe(\u6d41\u7a0b\u5b9a\u4e49)")
    @GetMapping(value={"/procDefBpmn/{processDefinitionId}"})
    public Result procDefBpmn(@PathVariable String processDefinitionId) {
        return Result.success(this.workflowServiceImpl.procDefBpmn(processDefinitionId));
    }

    @ApiOperation(value="\u6d41\u7a0b\u56fe(\u6d41\u7a0b\u5b9e\u4f8b)")
    @GetMapping(value={"/procInstBpmn/{processInstanceId}"})
    public Result procInstBpmn(@PathVariable String processInstanceId) {
        return Result.success(this.workflowServiceImpl.procInstBpmn(processInstanceId));
    }

    @ApiOperation(value="\u67e5\u770b\u6211\u7684\u5f85\u529e\u4efb\u52a1")
    @PostMapping(value={"/myTodoTask"})
    public Result myTodoTask(@RequestBody WorkflowTaskQuery query) {
        return Result.success(this.workflowDao.myTodoTask(query), this.workflowDao.myTodoTaskCount(query));
    }

    @ApiOperation(value="\u67e5\u770b\u6211\u7684\u5df2\u529e\u4efb\u52a1")
    @PostMapping(value={"/myCompletedTask"})
    public Result myCompletedTask(@RequestBody WorkflowTaskQuery query) {
        return Result.success(this.workflowDao.myCompletedTask(query), this.workflowDao.myCompletedTaskCount(query));
    }

    @ApiOperation(value="\u67e5\u770b\u6211\u7684\u521b\u5efa\u7684\u6d41\u7a0b")
    @PostMapping(value={"/myCreateProcess"})
    public Result myCreateProcess(@RequestBody WorkflowProcQuery query) {
        return Result.success(this.workflowDao.myCreateProcess(query), this.workflowDao.myCreateProcessCount(query));
    }

    @ApiOperation(value="\u67e5\u770b\u6211\u7684\u53c2\u4e0e\u7684\u6d41\u7a0b")
    @PostMapping(value={"/myParticipateProcess"})
    public Result myParticipateProcess(@RequestBody WorkflowProcQuery query) {
        return Result.success(this.workflowDao.myParticipateProcess(query), this.workflowDao.myParticipateProcessCount(query));
    }

    @ApiOperation(value="\u8bfb\u53d6\u5ba1\u6279\u610f\u89c1")
    @GetMapping(value={"/comments"})
    public Result comments(String processInstanceId) {
        return Result.success(this.workflowDao.comments(processInstanceId));
    }

    @ApiOperation(value="\u901a\u8fc7")
    @PostMapping(value={"/complete"})
    public Result complete(@RequestBody @Validated CompletePayLoad completePayLoad) {
        String currentUserId = JwtUtils.getUserId();
        this.workflowServiceImpl.complete(completePayLoad, currentUserId);
        return Result.success();
    }

    @ApiOperation(value="\u64a4\u56de")
    @PostMapping(value={"/withdraw"})
    public Result withdraw(@RequestBody @Validated WithdrawPayLoad withdrawPayLoad) {
        this.workflowServiceImpl.withdraw(withdrawPayLoad);
        return Result.success();
    }

    @ApiOperation(value="\u53ef\u9a73\u56de\u8282\u70b9")
    @GetMapping(value={"/backNodes"})
    public Result backNodes(String processInstanceId) {
        return Result.success(this.workflowServiceImpl.backNodes(processInstanceId));
    }

    @ApiOperation(value="\u9a73\u56de\u8282\u70b9")
    @PostMapping(value={"/back"})
    public Result back(@RequestBody @Validated BackPayLoad backPayLoad) {
        String currentUserId = JwtUtils.getUserId();
        this.workflowServiceImpl.back(backPayLoad, currentUserId);
        return Result.success();
    }

    @ApiOperation(value="\u52a0\u7b7e")
    @PostMapping(value={"/addSign"})
    public Result addSign(@RequestBody @Validated AddSignPayLoad addSignPayLoad) {
        this.workflowServiceImpl.addSign(addSignPayLoad);
        return Result.success();
    }

    @ApiOperation(value="\u59d4\u6d3e")
    @PostMapping(value={"/delegation"})
    public Result delegation(@RequestBody @Validated DelegationPayload delegationPayload) {
        this.workflowServiceImpl.delegation(delegationPayload);
        return Result.success();
    }

    @ApiOperation(value="\u8f6c\u529e")
    @PostMapping(value={"/transfer"})
    public Result transfer(@RequestBody @Validated TransferPayload transferPayload) {
        this.workflowServiceImpl.transfer(transferPayload);
        return Result.success();
    }

    @ApiOperation(value="\u6539\u53d8\u4efb\u52a1\u8d1f\u8d23\u4eba")
    @PostMapping(value={"/changeTaskAssigness"})
    public Result changeTaskAssigness(@RequestBody @Validated ChangeTaskAssignessPayLoad changeTaskAssignessPayLoad) {
        this.workflowServiceImpl.changeTaskAssigness(changeTaskAssignessPayLoad);
        return Result.success();
    }

    @ApiOperation(value="\u4f5c\u5e9f\u6d41\u7a0b")
    @PostMapping(value={"/invalid"})
    public Result invalid(@RequestBody @Validated InvalidProcInstPayload invalidProcInstPayload) {
        this.workflowServiceImpl.invalid(invalidProcInstPayload);
        return Result.success();
    }

    @ApiOperation(value="\u8bfb\u53d6\u5f53\u524d\u5904\u7406\u7684\u8282\u70b9")
    @GetMapping(value={"/currentTaskKeys"})
    public Result currentTaskKeys(String procInstId) {
        return Result.success(this.workflowServiceImpl.currentTaskKeys(procInstId));
    }

    @ApiOperation(value="\u4efb\u52a1\u8d1f\u8d23\u4eba\u914d\u7f6e\u7c7b\u578b")
    @GetMapping(value={"/taskLeadersTypes"})
    public Result taskLeadersTypes() {
        return Result.success(this.taskNodeConfigService.taskLeadersTypes());
    }

    @ApiOperation(value="\u8282\u70b9\u4fe1\u606f")
    @GetMapping(value={"/nodeInfo"})
    public Result nodeInfo(String procInstId) {
        return Result.success(this.workflowServiceImpl.nodeInfo(procInstId));
    }

    public WorkflowController(WorkflowServiceImpl workflowServiceImpl, WorkflowDao workflowDao, TaskNodeConfigService taskNodeConfigService) {
        this.workflowServiceImpl = workflowServiceImpl;
        this.workflowDao = workflowDao;
        this.taskNodeConfigService = taskNodeConfigService;
    }
}

