/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.controller;

import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.dao.UserDao;
import com.elitesland.workflow.dao.WorkflowDao;
import com.elitesland.workflow.exception.WorkflowException;
import com.elitesland.workflow.payload.ApprovePayload;
import com.elitesland.workflow.payload.BackPayLoad;
import com.elitesland.workflow.payload.CompletePayLoad;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.workflow.service.WorkflowServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5de5\u4f5c\u6d41openfeign\u63a5\u53e3", tags={"\u5de5\u4f5c\u6d41openfeign\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/workflow/api"})
public class WorkflowProvideController
implements WorkflowService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowProvideController.class);
    private final WorkflowServiceImpl workflowServiceImpl;
    private final WorkflowDao workflowDao;
    private final UserDao userDao;

    @ApiOperation(value="\u542f\u52a8\u5de5\u4f5c\u6d41")
    @PostMapping(value={"/startProcess"})
    public WorkflowResult<ProcessInfo> startProcess(@RequestBody @Validated StartProcessPayload payload) {
        return WorkflowResult.success((Object)this.workflowServiceImpl.startProcess(payload.getProcessDefinitionKey(), payload.getProcInstName(), payload.getBusinessKey(), payload.getVariables()));
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf")
    @PostMapping(value={"/setVariables"})
    public WorkflowResult setVariables(@RequestBody @Validated SetVariablesPayload payload) {
        this.workflowServiceImpl.setVariables(payload.getProcInstId(), payload.getVariables());
        return WorkflowResult.success(null);
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID,\u67e5\u8be2\u6d41\u7a0b\u5f53\u524d\u4efb\u52a1\u4fe1\u606f")
    @PostMapping(value={"/currentTaskInfos"})
    public WorkflowResult<HashMap<String, TaskInfo>> currentTaskInfos(@RequestBody @Validated CurrentTaskInfosPayload payload) {
        return WorkflowResult.success(this.workflowServiceImpl.currentTaskInfos(payload.getProcInstIds()));
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID,\u67e5\u8be2\u6d41\u7a0b\u5f53\u524d\u4efb\u52a1\u4fe1\u606f")
    @PostMapping(value={"/currentTaskInfo"})
    public WorkflowResult<TaskInfo> currentTaskInfo(String procInstId) {
        return WorkflowResult.success((Object)this.workflowServiceImpl.currentTaskInfo(procInstId));
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID,\u67e5\u8be2\u6d41\u7a0b\u5ba1\u6279\u4fe1\u606f")
    @PostMapping(value={"/commentInfos"})
    public WorkflowResult<ArrayList<CommentInfo>> commentInfos(String procInstId) {
        return WorkflowResult.success(this.workflowServiceImpl.commentInfos(procInstId));
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b,\u4e0d\u56de\u8c03\u4e1a\u52a1")
    @PostMapping(value={"/deleteProcess"})
    public WorkflowResult deleteProcess(@RequestBody @Validated DeleteProcessPayload payload) {
        this.workflowServiceImpl.deleteProcess(payload.getProcInstId(), payload.getComment());
        return WorkflowResult.success(null);
    }

    @ApiOperation(value="\u53ef\u9a73\u56de\u7684\u8282\u70b9")
    @GetMapping(value={"/canBackNodes"})
    public WorkflowResult canBackNodes(@RequestParam String procInstId) {
        System.out.println(procInstId);
        return WorkflowResult.success(this.workflowServiceImpl.backNodes(procInstId));
    }

    @ApiOperation(value="\u5ba1\u6279[\u540c\u610f/\u62d2\u7edd]")
    @PostMapping(value={"/approve"})
    public WorkflowResult approve(@RequestBody @Validated ApprovePayload payload) {
        log.info("\u5ba1\u6279\u53c2\u6570\uff1a{}", (Object)payload);
        String currentUserId = payload.getCurrentUserId().toString();
        if (!this.userDao.existUserId(currentUserId)) {
            throw new WorkflowException("\u7528\u6237(ID:" + currentUserId + ")\u4e0d\u5b58\u5728");
        }
        this.workflowServiceImpl.getProcessInstance(payload.getProcInstId());
        switch (payload.getAction()) {
            case AGREE: {
                String currentTaskId = this.workflowDao.currentTaskId(payload.getProcInstId());
                if (StringUtils.isBlank((CharSequence)currentTaskId)) {
                    throw new WorkflowException("\u6ca1\u6709\u53ef\u5ba1\u6279\u7684\u4efb\u52a1");
                }
                CompletePayLoad completePayLoad = new CompletePayLoad();
                completePayLoad.setTaskId(currentTaskId);
                completePayLoad.setComment(payload.getComment());
                this.workflowServiceImpl.complete(completePayLoad, currentUserId);
                break;
            }
            case REJECT: {
                if (StringUtils.isBlank((CharSequence)payload.getBackTaskId())) {
                    throw new WorkflowException("\u672a\u8bbe\u7f6e\u9a73\u56de\u7684\u76ee\u6807\u8282\u70b9");
                }
                BackPayLoad backPayLoad = new BackPayLoad();
                backPayLoad.setProcessInstanceId(payload.getProcInstId());
                backPayLoad.setTargetActInsId(payload.getBackTaskId());
                backPayLoad.setComment(payload.getComment());
                this.workflowServiceImpl.back(backPayLoad, currentUserId);
            }
        }
        return WorkflowResult.success(null);
    }

    public WorkflowProvideController(WorkflowServiceImpl workflowServiceImpl, WorkflowDao workflowDao, UserDao userDao) {
        this.workflowServiceImpl = workflowServiceImpl;
        this.workflowDao = workflowDao;
        this.userDao = userDao;
    }
}

