/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import cn.hutool.core.util.IdUtil;
import com.elitesland.commons.db.BaseDao;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.controller.AgentQuery;
import com.elitesland.workflow.domain.AgentPayload;
import com.elitesland.workflow.entity.Agent;
import com.elitesland.workflow.exception.WorkflowException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class AgentDao
extends BaseDao<Agent> {
    private static final Logger log = LoggerFactory.getLogger(AgentDao.class);
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<Agent> queryList(AgentQuery query) {
        String whereSQl = " where a.userId='" + query.getCurrentUserId() + "' and a.procDefKey=pd.key and a.tenantId=pd.tenantId ";
        String sql = "select     pd.key procDefKey ,    pd.name procDefName,    (select a.agentUserIds from wf_agent a " + whereSQl + " ) agentUserIds,    (select a.startTime from wf_agent a " + whereSQl + " ) startTime,    (select a.endTime from wf_agent a " + whereSQl + "  ) endTime from wf_procDef pd where #QUERY_WHERE_SQL#";
        return this.queryList(sql, query, Agent.class);
    }

    public long queryCount(AgentQuery query) {
        String sql = "select  count(1) from wf_procDef pd where #QUERY_WHERE_SQL#";
        return this.queryCount(sql, query);
    }

    public void save(AgentPayload agentPayload) {
        String agentUserIds = null;
        if (CollectionUtils.isNotEmpty(agentPayload.getAgentUserIds())) {
            agentUserIds = StringUtils.join(agentPayload.getAgentUserIds(), (String)",");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", agentPayload.getTenantId());
        params.put("userId", agentPayload.getUserId());
        params.put("procDefKey", agentPayload.getProcDefKey());
        params.put("agentUserIds", agentUserIds);
        params.put("startTime", agentPayload.getStartTime());
        params.put("endTime", agentPayload.getEndTime());
        String sql = "update wf_agent set agentUserIds=:agentUserIds,startTime=:startTime,endTime=:endTime  where  userId=:userId and procDefKey=:procDefKey";
        int row = this.namedParameterJdbcTemplate.update(sql, params);
        if (row == 0) {
            switch (SpringUtils.getDBType()) {
                case MySQL: {
                    sql = "insert into wf_agent (tenantId,userId,procDefKey,agentUserIds,startTime,endTime) values (:tenantId,:userId,:procDefKey,:agentUserIds,:startTime,:endTime)";
                    break;
                }
                case ORACLE: {
                    params.put("id", IdUtil.getSnowflakeNextId());
                    sql = "insert into wf_agent (id,tenantId,userId,procDefKey,agentUserIds,startTime,endTime) values (:id,:tenantId,:userId,:procDefKey,:agentUserIds,:startTime,:endTime)";
                    break;
                }
                default: {
                    throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
                }
            }
            this.namedParameterJdbcTemplate.update(sql, params);
        }
    }

    public AgentDao(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

