/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import com.elitesland.commons.db.BaseDao;
import com.elitesland.commons.db.BaseQuery;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.domain.search.CategorySearch;
import com.elitesland.workflow.entity.Category;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CategoryDao
extends BaseDao<Category> {
    private static final Logger log = LoggerFactory.getLogger(CategoryDao.class);

    public List<CategorySearch> queryList(BaseQuery query) {
        String sql = "select c.*, (select count(1) from wf_procDef pd where pd.categoryId=c.id) processNum from  wf_category c where #QUERY_WHERE_SQL#";
        return super.queryList(sql, query, CategorySearch.class);
    }

    @Override
    public long queryCount(BaseQuery query) {
        String sql = "select count(1) from  wf_category c where #QUERY_WHERE_SQL#";
        return super.queryCount(sql, query);
    }

    public long queryProcDefCount(List<Long> categorIds) {
        String sql = "select count(1) from wf_procDef where categoryId in (:ids)";
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("ids", categorIds);
        return (Long)SpringUtils.getNamedParameterJdbcTemplate().queryForObject(sql, params, Long.class);
    }
}

