/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import com.elitesland.commons.db.BaseDao;
import com.elitesland.commons.db.BaseQuery;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.domain.search.ProcDefSearch;
import com.elitesland.workflow.entity.ProcDef;
import com.elitesland.workflow.utils.WorkflowUtils;
import com.elitesland.workflow.vo.ProcDefVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ProcDefDao
extends BaseDao<ProcDef> {
    private static final Logger log = LoggerFactory.getLogger(ProcDefDao.class);

    @Override
    public long queryCount(BaseQuery query) {
        String sql = "select count(1) from wf_procDef pd left join wf_category c on pd.categoryId=c.id where #QUERY_WHERE_SQL#";
        return this.queryCount(sql, query);
    }

    public List<ProcDefSearch> queryList(BaseQuery query) {
        String sql = "select    pd.id,   c.name categoryName,   pd.name procDefName,   pd.key procDefKey,   pd.appPrefixUrl appPrefixUrl,   pd.state,   pd.supportInvalid from wf_procDef pd  left join wf_category c on pd.categoryId=c.id  where #QUERY_WHERE_SQL#";
        return this.queryList(sql, query, ProcDefSearch.class);
    }

    public String queryXmlById(long id) {
        try {
            String sql = "select xml from wf_procDef where id=?";
            return (String)SpringUtils.getJdbcTemplate().queryForObject(sql, String.class, new Object[]{id});
        }
        catch (Exception e) {
            return "";
        }
    }

    public Map<String, List<ProcDefVo>> procDefs() {
        HashMap<String, List<ProcDefVo>> result = new HashMap<String, List<ProcDefVo>>();
        String sql = "select    c.name categoryName,   pd.name procDefName,   pd.key,   pd.state from wf_procDef pd  inner join wf_category c on c.id=pd.categoryId  where pd.tenantId='" + WorkflowUtils.getTenantId() + "'";
        List list = SpringUtils.getJdbcTemplate().query(sql, (RowMapper)new BeanPropertyRowMapper(ProcDefVo.class));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(item -> {
                if (!result.containsKey(item.getCategoryName())) {
                    result.put(item.getCategoryName(), new ArrayList());
                }
                ((List)result.get(item.getCategoryName())).add(item);
            });
        }
        return result;
    }

    public boolean isDeploy(List<Long> ids) {
        String sql = "select count(1) from  ACT_RE_PROCDEF rp inner join wf_procDef p on p.key= rp.KEY_  where p.id in (:ids)";
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("ids", ids);
        return (Long)SpringUtils.getNamedParameterJdbcTemplate().queryForObject(sql, params, Long.class) > 0L;
    }

    public void supportInvalid(long id, boolean supportInvalid) {
        String sql = "update wf_procDef set supportInvalid=? where id=?";
        SpringUtils.getJdbcTemplate().update(sql, new Object[]{supportInvalid, id});
    }
}

