/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import com.elitesland.commons.db.BaseDao;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.controller.ProcInstQuery;
import com.elitesland.workflow.domain.ProcInstVo;
import com.elitesland.workflow.entity.ProcInst;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.exception.WorkflowException;
import com.elitesland.workflow.utils.WorkflowUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ProcInstDao
extends BaseDao<ProcInst> {
    private static final Logger log = LoggerFactory.getLogger(ProcInstDao.class);
    private final JdbcTemplate jdbcTemplate;

    public List<ProcInstVo> queryList(ProcInstQuery query) {
        String tenantId = WorkflowUtils.getTenantId();
        String sql = "select    pi.ID_ id,   (SELECT last_name from " + WorkflowUtils.getUserTable() + " where id = pi.START_USER_ID_) startUser,   pi.BUSINESS_KEY_ businessKey,    pi.START_TIME_ startTime,    pi.END_TIME_ endTime,    pi.DURATION_ duration,    wpi.procInstName procInstName,    wpi.status status,    pd.NAME_ procDefName ,   pd.KEY_ procDefKey ,";
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = sql + "   (select count(1) from ACT_RU_EXECUTION e where e.PROC_INST_ID_=pi.ID_  and e.SUSPENSION_STATE_=2 )>0 isSuspended,";
                sql = sql + "   (" + this.lackTaskAssigneeSql(true) + ") lackTaskAssigneeCount,";
                break;
            }
            case ORACLE: {
                sql = sql + "   (case when (SELECT count( 1 ) FROM ACT_RU_EXECUTION e WHERE e.PROC_INST_ID_ = pi.ID_  AND e.SUSPENSION_STATE_ = 2 ) > 0 then 1 else 0 end) isSuspended,";
                sql = sql + "   (" + this.lackTaskAssigneeSql(true) + ") lackTaskAssigneeCount,";
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        sql = sql + " wpd.categoryId  from ACT_HI_PROCINST pi  inner join ACT_RE_PROCDEF pd on pd.ID_=pi.PROC_DEF_ID_  left join wf_procInst wpi on wpi.procInstId=pi.PROC_INST_ID_  left join wf_procdef wpd on pd.KEY_ = wpd.key where pi.TENANT_ID_='" + tenantId + "' and pd.TENANT_ID_='" + tenantId + "' and wpi.tenantId='" + tenantId + "' and wpd.tenantId='" + tenantId + "'" + this.whereSql(query) + " and #QUERY_WHERE_SQL# order by pi.START_TIME_ desc ";
        return this.queryList(sql, query, ProcInstVo.class);
    }

    public long queryCount(ProcInstQuery query) {
        String tenantId = WorkflowUtils.getTenantId();
        String sql = "select  count(1)  from ACT_HI_PROCINST pi  inner join ACT_RE_PROCDEF pd on pd.ID_=pi.PROC_DEF_ID_  left join wf_procInst wpi on wpi.procInstId=pi.PROC_INST_ID_  LEFT JOIN wf_procdef wpd on pd.KEY_ = wpd.key where pi.TENANT_ID_='" + tenantId + "' and pd.TENANT_ID_='" + tenantId + "' and wpi.tenantId='" + tenantId + "' and wpd.tenantId='" + tenantId + "'" + this.whereSql(query) + " and #QUERY_WHERE_SQL#";
        System.out.println("++++++++" + sql);
        return this.queryCount(sql, query);
    }

    private String whereSql(ProcInstQuery query) {
        ArrayList<Object> sqls = new ArrayList<Object>();
        if (query.getException() != null) {
            if (query.getException().booleanValue()) {
                sqls.add(" and pi.END_TIME_ is null and  " + this.lackTaskAssigneeWhereSql(query.getException()));
            } else {
                sqls.add(" and " + this.lackTaskAssigneeWhereSql(query.getException()));
            }
        }
        if ("suspended".equals(query.getSuspensionState())) {
            sqls.add(" and (select count(1) from ACT_RU_EXECUTION e where e.PROC_INST_ID_=pi.ID_  and e.SUSPENSION_STATE_=2 )>0");
        }
        return StringUtils.join(sqls, (String)" ");
    }

    private String lackTaskAssigneeWhereSql(boolean isException) {
        return " (    select        count(1)     from ACT_RU_TASK task      where            task.PROC_INST_ID_=pi.PROC_INST_ID_             and            (               select count(1)                from ACT_HI_IDENTITYLINK link                where                    link.TASK_ID_=task.ID_                    and                    link.TYPE_ in ('assignee','candidate')                               )=0 )" + (isException ? ">0" : "=0");
    }

    private String lackTaskAssigneeSql(boolean isException) {
        String sql = this.lackTaskAssigneeWhereSql(isException);
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                return sql;
            }
            case ORACLE: {
                return " (case when (" + sql + ") then 1 else 0 end) ";
            }
        }
        throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
    }

    public ProcInstStatus queryStatus(String procInstId) {
        try {
            String sql = "select status from wf_procInst where procInstId=? ";
            String status = (String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{procInstId});
            return ProcInstStatus.valueOf((String)status);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void updateStatus(String procInstId, ProcInstStatus status) {
        String sql = "update wf_procInst set status=? where procInstId=?";
        this.jdbcTemplate.update(sql, new Object[]{status.name(), procInstId});
    }

    public ProcInstDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

