/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import com.elitesland.commons.utils.DBUtils;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.domain.SelectOption;
import com.elitesland.workflow.utils.WorkflowUtils;
import com.elitesland.workflow.vo.UserVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class QueryDao {
    private static final Logger log = LoggerFactory.getLogger(QueryDao.class);
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<SelectOption> categorys() {
        String sql = "select id value ,name label from wf_category where " + this.tenantIdSql(null);
        System.out.println(sql);
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(SelectOption.class));
    }

    public List<SelectOption> procDefs() {
        String sql = "select def.key value , def.name label from wf_procDef def where " + this.tenantIdSql("def");
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(SelectOption.class));
    }

    public List<SelectOption> getUsers() {
        String sql = " select u.id  ,u.first_name firstname ,u.last_name lastname,u.username from " + WorkflowUtils.getUserTable() + " u ";
        if (!SpringUtils.hasTenant()) {
            sql = sql + "  where u.enabled=1 ";
        } else {
            String tenantId = WorkflowUtils.getTenantId();
            sql = sql + " left join  " + WorkflowUtils.getTenantUserTable() + " t on u.id=t.sys_user_id where u.enabled=1 ";
            sql = "0".equals(tenantId) ? sql + " and  t.sys_tenant_id is null " : sql + " and t.sys_tenant_id = " + tenantId;
        }
        System.out.println(sql);
        List userVoList = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(UserVo.class));
        if (CollectionUtils.isEmpty((Collection)userVoList)) {
            return new ArrayList<SelectOption>();
        }
        return userVoList.stream().map(userVo -> userVo.getOption()).collect(Collectors.toList());
    }

    public List<String> queryLeaderUserId(String userId) {
        String sql;
        List userIds;
        String org_emp;
        String sql2;
        List userIds2;
        String org_employee;
        ArrayList<String> leaderUserIds = new ArrayList<String>();
        Map<String, List<String>> tableColumn = DBUtils.getTableColumns();
        if (tableColumn.containsKey(org_employee = "org_employee") && tableColumn.get(org_employee).contains("report_to_id") && tableColumn.get(org_employee).contains("sys_user_id") && CollectionUtils.isNotEmpty((Collection)(userIds2 = this.jdbcTemplate.queryForList(sql2 = "select sys_user_id from org_employee where id in (select report_to_id from org_employee where sys_user_id=?) ", String.class, new Object[]{userId})))) {
            leaderUserIds.addAll(userIds2);
        }
        if (tableColumn.containsKey(org_emp = "org_emp") && tableColumn.get(org_emp).contains("report_to_id") && tableColumn.get(org_emp).contains("user_id") && CollectionUtils.isNotEmpty((Collection)(userIds = this.jdbcTemplate.queryForList(sql = "select user_id from org_emp where id in (select report_to_id from org_emp where user_id=?) ", String.class, new Object[]{userId})))) {
            leaderUserIds.addAll(userIds);
        }
        return leaderUserIds;
    }

    private String deleteFlag() {
        return "(delete_flag = 0 or delete_flag is null)";
    }

    private String deleteFlag(String tableAlias) {
        return "(" + tableAlias + ".delete_flag = 0 or " + tableAlias + ".delete_flag is null)";
    }

    private String tenantIdSql(String tableAlias) {
        return (String)(StringUtils.isBlank((CharSequence)tableAlias) ? "" : tableAlias + ".") + "tenantId='" + WorkflowUtils.getTenantId() + "' ";
    }

    public QueryDao(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

