/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import com.elitesland.commons.db.Where;
import com.elitesland.workflow.controller.TaskInstQuery;
import com.elitesland.workflow.utils.WorkflowUtils;
import com.elitesland.workflow.vo.TaskInst;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class TaskInstDao {
    private static final Logger log = LoggerFactory.getLogger(TaskInstDao.class);
    private final JdbcTemplate jdbcTemplate;

    public List<TaskInst> queryList(TaskInstQuery query) {
        Where where = query.getWhere();
        String sql = "select task.ID_ taskId,task.Name_ taskName," + WorkflowUtils.taskLeaderSql("taskLeaders") + "," + WorkflowUtils.taskHandlerSql("taskHandler") + ",task.START_TIME_ startTime,task.END_TIME_ endTime,task.DURATION_ duration,   pd.NAME_ procDefName,    pd.KEY_ procDefKey,    pi.PROC_INST_ID_  processInstanceId,   pi.BUSINESS_KEY_ businessKey  from ACT_HI_TASKINST task  inner join ACT_HI_PROCINST pi on task.PROC_INST_ID_=pi.ID_  inner join ACT_RE_PROCDEF pd on pi.PROC_DEF_ID_=pd.ID_  where " + where.getSql() + " order by task.START_TIME_ asc";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(TaskInst.class), where.getValues().toArray());
    }

    public TaskInstDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

