/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import com.elitesland.commons.db.BaseDao;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.workflow.entity.TaskNodeConfig;
import com.elitesland.workflow.utils.WorkflowUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class TaskNodeConfigDao
extends BaseDao<TaskNodeConfig> {
    private static final Logger log = LoggerFactory.getLogger(TaskNodeConfigDao.class);

    public TaskNodeConfig query(String procDefKey, String taskDefId) {
        String tenantId = WorkflowUtils.getTenantId();
        try {
            String sql = "select * from wf_task_node_config  where procDefKey=?  and tenantId=?  and taskDefId=? ";
            return (TaskNodeConfig)SpringUtils.getJdbcTemplate().queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(TaskNodeConfig.class), new Object[]{procDefKey, tenantId, taskDefId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public List<TaskNodeConfig> query(String procDefKey, List<String> taskDefIds) {
        String tenantId = WorkflowUtils.getTenantId();
        try {
            String sql = "select * from wf_task_node_config  where procDefKey=:procDefKey  and tenantId=:tenantId  and taskDefId in (:taskDefIds)  ";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("procDefKey", procDefKey);
            params.put("tenantId", tenantId);
            params.put("taskDefIds", taskDefIds);
            return SpringUtils.getNamedParameterJdbcTemplate().query(sql, params, (RowMapper)new BeanPropertyRowMapper(TaskNodeConfig.class));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

