/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import com.elitesland.workflow.utils.WorkflowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class UserDao {
    private static final Logger log = LoggerFactory.getLogger(UserDao.class);
    private final JdbcTemplate jdbcTemplate;

    public String queryName(Long userId) {
        try {
            String sql = "select last_name from " + WorkflowUtils.getUserTable() + " where id=?";
            return (String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean existUserId(String userId) {
        String sql = "select count(1) from " + WorkflowUtils.getUserTable() + " where id=?";
        Long count = (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{userId});
        return count > 0L;
    }

    public UserDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

