/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.dao;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.commons.db.Where;
import com.elitesland.commons.utils.JwtUtils;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.commons.utils.SqlUtils;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.controller.WorkflowProcQuery;
import com.elitesland.workflow.controller.WorkflowTaskQuery;
import com.elitesland.workflow.domain.ActInst;
import com.elitesland.workflow.domain.Comment;
import com.elitesland.workflow.domain.ProcessDefinitionHistory;
import com.elitesland.workflow.domain.TodoTaskNode;
import com.elitesland.workflow.domain.search.MyCompletedTaskSearch;
import com.elitesland.workflow.domain.search.MyTodoTaskSearch;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.exception.WorkflowException;
import com.elitesland.workflow.utils.CollUtils;
import com.elitesland.workflow.utils.WorkflowUtils;
import com.elitesland.workflow.vo.BackNode;
import com.elitesland.workflow.vo.MyCreateProcess;
import com.elitesland.workflow.vo.MyParticipateProcess;
import com.elitesland.workflow.vo.PreNode;
import com.elitesland.workflow.vo.RunTask;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class WorkflowDao {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDao.class);
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    String myParticipateProcessIdSql = " pi.PROC_INST_ID_ in (select PROC_INST_ID_ from act_hi_taskinst where ASSIGNEE_=?) ";

    public List<ProcessDefinitionHistory> processDefinitionHistory(String processDefinitionKey) {
        String tenantId = WorkflowUtils.getTenantId();
        Object sql = "select    pd.ID_ id,    pd.KEY_ procDefKey,    pd.VERSION_ version, ";
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = (String)sql + "   if(pd.SUSPENSION_STATE_=2,true,false) isSuspended,";
                break;
            }
            case ORACLE: {
                sql = (String)sql + " (case when pd.SUSPENSION_STATE_=2 then 1 else 0 end) isSuspended, ";
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        sql = (String)sql + "   (select count(1) from ACT_HI_PROCINST where PROC_DEF_ID_ like pd.ID_ and END_TIME_ is null) runingProcInst,    (select count(1) from ACT_HI_PROCINST where PROC_DEF_ID_ like pd.ID_ and END_TIME_ is not null) endProcInst,    (select count(1) from ACT_HI_PROCINST where PROC_DEF_ID_ like pd.ID_ ) totalProcInst from ACT_RE_PROCDEF pd where pd.KEY_=? and pd.TENANT_ID_=? order by pd.VERSION_ desc ";
        return this.jdbcTemplate.query((String)sql, (RowMapper)new BeanPropertyRowMapper(ProcessDefinitionHistory.class), new Object[]{processDefinitionKey, tenantId});
    }

    private String taskParams(String sql, WorkflowTaskQuery query, Map<String, Object> params) {
        if (StringUtils.isNotBlank((CharSequence)query.getBusinessKey())) {
            sql = (String)sql + " and pi.BUSINESS_KEY_ like :businessKey";
            params.put("businessKey", "%" + query.getBusinessKey() + "%");
        }
        if (CollectionUtils.isNotEmpty(query.getProcDefKeys())) {
            sql = (String)sql + " and pd.KEY_ in (:procDefKeys)";
            params.put("procDefKeys", query.getProcDefKeys());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getProcInstName())) {
            sql = (String)sql + " and wpi.procInstName like :procInstName";
            params.put("procInstName", "%" + query.getProcInstName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)query.getStartUserId())) {
            sql = (String)sql + " and pi.START_USER_ID_ = :startUserId";
            params.put("startUserId", query.getStartUserId());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getStartUserName())) {
            sql = (String)sql + " and pi.START_USER_ID_ in  (select id from " + WorkflowUtils.getUserTable() + " where last_name like :startUserName ) ";
            params.put("startUserName", "%" + query.getStartUserName() + "%");
        }
        return sql;
    }

    private String procQueryParams(String sql, WorkflowProcQuery query, Map<String, Object> params) {
        return null;
    }

    public List<MyTodoTaskSearch> myTodoTask(WorkflowTaskQuery query) {
        String currentUserId = JwtUtils.getUserId();
        Object sql = "select    task.ID_ taskId,    task.NAME_ taskName, " + WorkflowUtils.taskLeaderSql("taskLeaders") + "," + WorkflowUtils.taskHandlerSql("taskHandler") + ",  (SELECT last_name from " + WorkflowUtils.getUserTable() + " where id = pi.START_USER_ID_) startUser,   pd.KEY_ procDefKey,    pi.ID_ processInstanceId,    pi.BUSINESS_KEY_ businessKey,    pi.START_TIME_ startTime,    pi.END_TIME_ endTime,    wpi.procInstName procInstName,    wpi.status status from  ACT_RU_TASK task inner join  ACT_HI_PROCINST pi     on pi.ID_=task.PROC_INST_ID_ inner join  ACT_RE_PROCDEF pd      on pd.ID_=task.PROC_DEF_ID_ left  join  wf_procInst wpi        on wpi.procInstId=pi.PROC_INST_ID_ where (" + WorkflowUtils.isTaskHandlerSql(currentUserId) + " or " + WorkflowUtils.isTaskAgentSql("'%," + currentUserId + ",%'") + ") ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql = this.taskParams((String)sql, query, params);
        if (StringUtils.isBlank((CharSequence)query.getSort())) {
            query.setSort("startTime DESC");
        }
        sql = (String)sql + query.getSortSql();
        sql = SqlUtils.handPage((String)sql, query);
        return this.namedParameterJdbcTemplate.query((String)sql, params, (RowMapper)new BeanPropertyRowMapper(MyTodoTaskSearch.class));
    }

    public long myTodoTaskCount(WorkflowTaskQuery query) {
        String currentUserId = JwtUtils.getUserId();
        Object sql = "select count(1) from  ACT_RU_TASK task inner join  ACT_HI_PROCINST pi     on pi.ID_=task.PROC_INST_ID_ inner join  ACT_RE_PROCDEF pd      on pd.ID_=task.PROC_DEF_ID_ left  join  wf_procInst wpi        on wpi.procInstId=pi.PROC_INST_ID_ where (" + WorkflowUtils.isTaskHandlerSql(currentUserId) + " or " + WorkflowUtils.isTaskAgentSql("'%," + currentUserId + ",%'") + ") ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql = this.taskParams((String)sql, query, params);
        return (Long)this.namedParameterJdbcTemplate.queryForObject((String)sql, params, Long.class);
    }

    public List<MyCompletedTaskSearch> myCompletedTask(WorkflowTaskQuery query) {
        String currentUserId = JwtUtils.getUserId();
        Object sql = "select    pd.KEY_  procDefKey ,   pi.ID_ processInstanceId,   (SELECT last_name from " + WorkflowUtils.getUserTable() + " where id = pi.START_USER_ID_) startUser,   pi.BUSINESS_KEY_ businessKey,    wpi.procInstName procInstName ,   wpi.status status ,   task.ID_ taskId,    task.NAME_ taskName,    task.START_TIME_ startTime,    task.END_TIME_ endTime, " + WorkflowUtils.taskLeaderSql("taskLeaders") + "," + WorkflowUtils.taskHandlerSql("taskHandler") + "from  ACT_HI_TASKINST task inner join ACT_HI_PROCINST pi on pi.ID_=task.PROC_INST_ID_ left join  wf_procInst wpi on wpi.procInstId=pi.PROC_INST_ID_ inner join ACT_RE_PROCDEF pd on pd.ID_=task.PROC_DEF_ID_ where  task.ASSIGNEE_= '" + currentUserId + "' and task.END_TIME_ is not null";
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql = this.taskParams((String)sql, query, params);
        if (StringUtils.isBlank((CharSequence)query.getSort())) {
            query.setSort("endTime DESC");
        }
        sql = (String)sql + query.getSortSql();
        sql = SqlUtils.handPage((String)sql, query);
        return this.namedParameterJdbcTemplate.query((String)sql, params, (RowMapper)new BeanPropertyRowMapper(MyCompletedTaskSearch.class));
    }

    public long myCompletedTaskCount(WorkflowTaskQuery query) {
        String currentUserId = JwtUtils.getUserId();
        Object sql = "select  count(1) from  ACT_HI_TASKINST task inner join ACT_HI_PROCINST pi on pi.ID_=task.PROC_INST_ID_ left join  wf_procInst wpi on wpi.procInstId=pi.PROC_INST_ID_ inner join ACT_RE_PROCDEF pd on pd.ID_=task.PROC_DEF_ID_ where  task.ASSIGNEE_= '" + currentUserId + "' and task.END_TIME_ is not null";
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql = this.taskParams((String)sql, query, params);
        return (Long)this.namedParameterJdbcTemplate.queryForObject((String)sql, params, Long.class);
    }

    private String getStatusSql(WorkflowProcQuery query) {
        List<String> statusList = query.getStatusList();
        if (CollectionUtils.isEmpty(statusList)) {
            return "";
        }
        ArrayList<CallSite> values = new ArrayList<CallSite>();
        for (String status : statusList) {
            if (!StringUtils.isNotBlank((CharSequence)status)) continue;
            values.add((CallSite)((Object)("'" + status.trim() + "'")));
        }
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        return " and wpi.status in ( " + StringUtils.join(values, (String)",") + ")";
    }

    public List<MyCreateProcess> myCreateProcess(WorkflowProcQuery query) {
        Where where = query.getWhere();
        if (StringUtils.isBlank((CharSequence)query.getSort())) {
            query.setSort("startTime DESC");
        }
        Object sql = "select    pd.KEY_  procDefKey ,   pi.PROC_INST_ID_ processInstanceId ,   pi.BUSINESS_KEY_ businessKey,    pi.START_TIME_ startTime,    pi.END_TIME_ endTime,   (SELECT last_name from " + WorkflowUtils.getUserTable() + " where id = pi.START_USER_ID_) startUser,   wpi.procInstName procInstName ,   wpi.status status from  ACT_HI_PROCINST pi inner join ACT_RE_PROCDEF pd on pd.ID_=pi.PROC_DEF_ID_ left join  wf_procInst wpi on wpi.procInstId=pi.PROC_INST_ID_ where  pi.START_USER_ID_=? " + this.getStatusSql(query) + " and " + where.getSql() + query.getSortSql();
        sql = SqlUtils.handPage((String)sql, query);
        List<Object> values = where.getValues();
        values.add(0, JwtUtils.getUserId());
        List myCreateProcesses = this.jdbcTemplate.query((String)sql, (RowMapper)new BeanPropertyRowMapper(MyCreateProcess.class), values.toArray());
        if (CollectionUtils.isNotEmpty((Collection)myCreateProcesses)) {
            Map myCreateProcessMap = myCreateProcesses.stream().filter(myCreateProcesse -> StringUtils.isNotBlank((CharSequence)myCreateProcesse.getProcessInstanceId())).collect(Collectors.toMap(MyCreateProcess::getProcessInstanceId, Function.identity()));
            HashMap<String, TaskInfo> taskInfoMap = this.currentTaskInfos(CollUtils.toHashSet(myCreateProcessMap.keySet()));
            taskInfoMap.forEach((key, value) -> {
                MyCreateProcess myCreateProcess = (MyCreateProcess)myCreateProcessMap.get(key);
                myCreateProcess.setTaskLeaders(value.getTaskLeaders());
            });
        }
        return myCreateProcesses;
    }

    public long myCreateProcessCount(WorkflowProcQuery query) {
        Where where = query.getWhere();
        String sql = "select count(1) from  ACT_HI_PROCINST pi inner join ACT_RE_PROCDEF pd on pd.ID_=pi.PROC_DEF_ID_ left join  wf_procInst wpi on wpi.procInstId=pi.PROC_INST_ID_ where  pi.START_USER_ID_=? " + this.getStatusSql(query) + " and " + where.getSql();
        List<Object> values = where.getValues();
        values.add(0, JwtUtils.getUserId());
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, values.toArray());
    }

    public Object myParticipateProcess(WorkflowProcQuery query) {
        Where where = query.getWhere();
        if (StringUtils.isBlank((CharSequence)query.getSort())) {
            query.setSort("startTime DESC");
        }
        Object sql = "select    pd.KEY_  procDefKey ,   pi.PROC_INST_ID_ processInstanceId ,   pi.BUSINESS_KEY_ businessKey,    pi.START_TIME_ startTime,    pi.END_TIME_ endTime,   (SELECT last_name from " + WorkflowUtils.getUserTable() + " where id = pi.START_USER_ID_) startUser,   wpi.procInstName procInstName ,   wpi.status status from  ACT_HI_PROCINST pi inner join ACT_RE_PROCDEF pd on pd.ID_=pi.PROC_DEF_ID_ left join  wf_procInst wpi on wpi.procInstId=pi.PROC_INST_ID_ where " + this.myParticipateProcessIdSql + this.getStatusSql(query) + " and " + where.getSql() + query.getSortSql();
        sql = SqlUtils.handPage((String)sql, query);
        List<Object> values = where.getValues();
        values.add(0, JwtUtils.getUserId());
        List myParticipateProcesses = this.jdbcTemplate.query((String)sql, (RowMapper)new BeanPropertyRowMapper(MyParticipateProcess.class), values.toArray());
        if (CollectionUtils.isNotEmpty((Collection)myParticipateProcesses)) {
            Map myParticipateProcesseMap = myParticipateProcesses.stream().filter(myCreateProcesse -> StringUtils.isNotBlank((CharSequence)myCreateProcesse.getProcessInstanceId())).collect(Collectors.toMap(MyParticipateProcess::getProcessInstanceId, Function.identity()));
            HashMap<String, TaskInfo> taskInfoMap = this.currentTaskInfos(CollUtils.toHashSet(myParticipateProcesseMap.keySet()));
            taskInfoMap.forEach((key, value) -> {
                MyParticipateProcess myParticipateProcess = (MyParticipateProcess)myParticipateProcesseMap.get(key);
                myParticipateProcess.setTaskLeaders(value.getTaskLeaders());
            });
        }
        return myParticipateProcesses;
    }

    public long myParticipateProcessCount(WorkflowProcQuery query) {
        Where where = query.getWhere();
        String sql = "select count(1) from  ACT_HI_PROCINST pi inner join ACT_RE_PROCDEF pd on pd.ID_=pi.PROC_DEF_ID_ left join  wf_procInst wpi on wpi.procInstId=pi.PROC_INST_ID_ where " + this.myParticipateProcessIdSql + this.getStatusSql(query) + " and " + where.getSql();
        List<Object> values = where.getValues();
        values.add(0, JwtUtils.getUserId());
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, values.toArray());
    }

    public List<Comment> comments(String processInstanceId) {
        return this.comments(processInstanceId, null);
    }

    public List<Comment> comments(String processInstanceId, List<ActionType> actionTypes) {
        String sql = "select    c.id id ,   c.type type ,   c.time time ,    c.message message,    c.taskId taskId,   task.TASK_DEF_KEY_ taskKey,   task.NAME_ taskName," + WorkflowUtils.taskLeaderSql("taskLeaders") + "," + WorkflowUtils.taskHandlerSql("taskHandler") + ",   u.last_name userName from ACT_HI_TASKINST  task left join wf_comment c on task.id_=c.taskId left join " + WorkflowUtils.getUserTable() + " u on u.id=c.userId where  task.PROC_INST_ID_=:processInstanceId ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        if (CollectionUtils.isNotEmpty(actionTypes)) {
            sql = sql + " and c.type in (:types)";
            params.put("types", actionTypes.stream().map(item -> item.name()).collect(Collectors.toList()));
        }
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = sql + "order by  task.END_TIME_ is null , c.time is null, c.time asc  ";
                break;
            }
            case ORACLE: {
                sql = sql + "order by c.time asc nulls last ";
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        System.out.println(sql);
        return this.namedParameterJdbcTemplate.query(sql, params, (RowMapper)new BeanPropertyRowMapper(Comment.class));
    }

    public List<CommentInfo> commentInfos(String processInstanceId) {
        String sql = "select    task.TASK_DEF_KEY_ taskDefKey,   task.NAME_ taskName,   c.type type ,   u.last_name userName,   u.id userId,   c.time time ,    c.message comment from ACT_HI_TASKINST  task left join wf_comment c on task.id_=c.taskId left join " + WorkflowUtils.getUserTable() + " u on u.id=c.userId where  task.PROC_INST_ID_=:processInstanceId ";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = sql + "order by  task.END_TIME_ is null , c.time is null, c.time asc  ";
                break;
            }
            case ORACLE: {
                sql = sql + "order by  c.time asc  nulls last ";
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        return this.namedParameterJdbcTemplate.query(sql, params, (RowMapper)new BeanPropertyRowMapper(CommentInfo.class));
    }

    public CommentInfo queryLastComment(String processInstanceId) {
        Object sql = "select    task.TASK_DEF_KEY_ taskDefKey,   task.NAME_ taskName,   c.type " + SqlUtils.getFieldAlias("type") + ",   u.last_name userName,   u.id userId,   c.time " + SqlUtils.getFieldAlias("time") + ",   c.message  " + SqlUtils.getFieldAlias("comment") + "from ACT_HI_TASKINST  task left join wf_comment c on task.id_=c.taskId left join " + WorkflowUtils.getUserTable() + " u on u.id=c.userId where  task.PROC_INST_ID_=:processInstanceId order by c.id desc ";
        sql = SqlUtils.limit1((String)sql);
        System.out.println((String)sql);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        try {
            return (CommentInfo)this.namedParameterJdbcTemplate.queryForObject((String)sql, params, (RowMapper)new BeanPropertyRowMapper(CommentInfo.class));
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> taskRelevantUserIds(String taskId, String procDefKey) {
        ArrayList<String> taskRelevantUserIds = new ArrayList<String>();
        String sql = "select USER_ID_ from ACT_HI_IDENTITYLINK where TYPE_ in ('assignee','candidate') and TASK_ID_=?";
        List taskUserIds = this.jdbcTemplate.queryForList(sql, String.class, new Object[]{taskId});
        log.info("\u67e5\u8be2\u4efb\u52a1\u7684\u76f8\u5173\u4eba\u5458:{},\u5019\u9009\u4eba+\u5206\u914d\u4efb\u52a1\u4eba:{}", (Object)taskId, (Object)taskUserIds);
        if (CollectionUtils.isNotEmpty((Collection)taskUserIds)) {
            taskRelevantUserIds.addAll(taskUserIds);
            sql = "select agent.agentUserIds from ACT_RU_TASK task  inner join wf_agent agent on agent.procDefKey=:procDefKey where task.ID_=:taskId and agent.userId in (:userIds)";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("procDefKey", procDefKey);
            params.put("taskId", taskId);
            params.put("userIds", taskUserIds);
            List agentUserIdList = this.namedParameterJdbcTemplate.queryForList(sql, params, String.class);
            log.info("\u67e5\u8be2\u4efb\u52a1\u7684\u76f8\u5173\u4eba\u5458:{},\u4efb\u52a1\u4ee3\u529e\u4eba:{}", (Object)taskId, (Object)agentUserIdList);
            if (CollectionUtils.isNotEmpty((Collection)agentUserIdList)) {
                agentUserIdList.forEach(agentUserIds -> Arrays.stream(agentUserIds.split(",")).forEach(agentUserId -> taskRelevantUserIds.add((String)agentUserId)));
            }
        }
        return taskRelevantUserIds;
    }

    public void deleteActivity(List<String> activityIds) {
        String sql = "delete from act_hi_actinst where  ID_ in :activityIds";
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("activityIds", activityIds);
        this.namedParameterJdbcTemplate.update(sql, params);
    }

    public long countSubTaskCount(String parentTaskId) {
        String sql = "select count(1) from ACT_RU_TASK where PARENT_TASK_ID_=?";
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{parentTaskId});
    }

    public List<BackNode> queryBackNodes(String processInstanceId) {
        String tenantId = WorkflowUtils.getTenantId();
        String processDefinitionKey = WorkflowUtils.getProcessDefinitionKeyByProcessInstanceId(processInstanceId);
        String sql = "select    actInst.ID_ actId,   actInst.EXECUTION_ID_ executionId,   actInst.ACT_NAME_ actName,   actInst.ACT_TYPE_ actType,    actInst.ACT_ID_ actDefKey,   actInst.END_TIME_ endTime,   actInst.DELETE_REASON_ deleteReason,   c.type commentType,    c.message commentMessage,    u.last_name username from ACT_RU_ACTINST actInst left join wf_comment c on  actInst.TASK_ID_=c.taskId left join " + WorkflowUtils.getUserTable() + " u on u.id=c.userId left join wf_task_node_config taskConfig on taskConfig.taskDefId = actInst.ACT_ID_  where    actInst.PROC_INST_ID_=?    and    actInst.ACT_TYPE_ in  ('userTask','parallelGateway')    and    (taskConfig.supportRejectedTo is null or  taskConfig.supportRejectedTo=1)    and    taskConfig.tenantId=?    and    taskConfig.procDefKey=? ";
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = sql + "order by actInst.END_TIME_ is null , actInst.END_TIME_  ASC  ";
                break;
            }
            case ORACLE: {
                sql = sql + "order by  actInst.END_TIME_  ASC nulls last ";
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(BackNode.class), new Object[]{processInstanceId, tenantId, processDefinitionKey});
    }

    public List<ActInst> queryActInsts(String processInstanceId) {
        Object sql = " select    EXECUTION_ID_ executionId,    ACT_ID_ actDefKey,    ACT_TYPE_ actType,    DELETE_REASON_ deleteReason, ";
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                sql = (String)sql + "   if(END_TIME_ is not null,'green','red') className ";
                break;
            }
            case ORACLE: {
                sql = (String)sql + " (case when END_TIME_ is not null then 'green' else 'red' end) className ";
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
        sql = (String)sql + " from  ACT_HI_ACTINST where PROC_INST_ID_=? order by START_TIME_ desc , END_TIME_ desc ";
        return this.jdbcTemplate.query((String)sql, (RowMapper)new BeanPropertyRowMapper(ActInst.class), new Object[]{processInstanceId});
    }

    public boolean isAssignee(String taskId, String currentUserId) {
        String sql = "select count(1) from ACT_HI_IDENTITYLINK where TASK_ID_=? and USER_ID_=? and TYPE_ in ('assignee','candidate')";
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{taskId, currentUserId}) > 0L;
    }

    public List<TodoTaskNode> todoTaskIds(String processInstanceId, String currentUserId) {
        String sql = "select    task.ID_ taskId,    task.TASK_DEF_KEY_ taskDefKey,    pd.KEY_ procDefKey from  ACT_RU_TASK  task inner join ACT_RE_PROCDEF pd on pd.ID_=task.PROC_DEF_ID_ where    task.PROC_INST_ID_ = ? and    (" + WorkflowUtils.isTaskHandlerSql(currentUserId) + "       or " + WorkflowUtils.isTaskAgentSql("?") + "   )";
        log.info("\u53ef\u5ba1\u6279\u4efb\u52a1\u7684SQL:{}", (Object)sql);
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(TodoTaskNode.class), new Object[]{processInstanceId, "%," + currentUserId + ",%"});
    }

    public String currentTaskId(String processInstanceId) {
        String sql = "select    task.ID_ taskId  from  ACT_RU_TASK  task inner join ACT_RE_PROCDEF pd on pd.ID_=task.PROC_DEF_ID_ where    task.PROC_INST_ID_ = ? ";
        log.info("\u53ef\u5ba1\u6279\u4efb\u52a1\u7684SQL:{}", (Object)sql);
        return (String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{processInstanceId});
    }

    public String canWithdrawTaskDefKey(String procInstId, String currentUserId) {
        String sql = "SELECT  EXECUTION_ID_ executionId ,  ACT_ID_ actDefKey ,  ASSIGNEE_ taskAssignee FROM  ACT_HI_ACTINST hiTask  WHERE  ACT_TYPE_ = 'userTask'   AND END_TIME_ IS NOT NULL   AND EXECUTION_ID_ IN ( SELECT EXECUTION_ID_ FROM ACT_RU_TASK WHERE PROC_INST_ID_ = ? )  ORDER BY  END_TIME_ ASC";
        List actInsts = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(ActInst.class), new Object[]{procInstId});
        if (CollectionUtils.isEmpty((Collection)actInsts)) {
            return null;
        }
        HashMap<String, ActInst> canWithdrawTasks = new HashMap<String, ActInst>();
        for (ActInst actInst : actInsts) {
            canWithdrawTasks.put(actInst.getExecutionId(), actInst);
        }
        for (ActInst canWithdrawTask : canWithdrawTasks.values()) {
            if (!currentUserId.equals(canWithdrawTask.getTaskAssignee())) continue;
            return canWithdrawTask.getActDefKey();
        }
        return null;
    }

    public String getActDefKey(String actId) {
        String sql = "select ACT_ID_ from ACT_HI_ACTINST where ID_=?";
        return (String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{actId});
    }

    public String getInitiator(String procInstId) {
        String sql = "select TEXT_  from  ACT_RU_VARIABLE where PROC_INST_ID_=? and NAME_='initiator' and TYPE_='string'";
        return (String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{procInstId});
    }

    public HashMap<String, TaskInfo> currentTaskInfos(HashSet<String> procInstIds) {
        if (CollectionUtil.isEmpty(procInstIds)) {
            return new HashMap<String, TaskInfo>();
        }
        Object sql = "select    task.PROC_INST_ID_ procInstId ,   task.NAME_ taskName ,    task.ID_ taskId ,    task.TASK_DEF_KEY_ taskDefKey , " + WorkflowUtils.taskLeaderSql("taskLeaders") + "," + WorkflowUtils.taskLeaderSql("id", "taskLeaderUserIds") + " from ACT_RU_TASK task where task.PROC_INST_ID_ in (:procInstIds)";
        HashMap<String, HashSet<String>> params = new HashMap<String, HashSet<String>>();
        params.put("procInstIds", procInstIds);
        List taskInfos = this.namedParameterJdbcTemplate.query((String)sql, params, (RowMapper)new BeanPropertyRowMapper(TaskInfo.class));
        HashMap<String, TaskInfo> currentTaskInfos = new HashMap<String, TaskInfo>();
        for (TaskInfo taskInfo : taskInfos) {
            currentTaskInfos.put(taskInfo.getProcInstId(), taskInfo);
        }
        for (String procInstId : procInstIds) {
            if (currentTaskInfos.containsKey(procInstId)) continue;
            TaskInfo taskInfo = new TaskInfo();
            taskInfo.setProcInstId(procInstId);
            currentTaskInfos.put(procInstId, taskInfo);
        }
        sql = "select  rt.PROC_INST_ID_     from  ACT_RU_TASK rt   inner join ACT_HI_ACTINST ha on rt.ID_=ha.TASK_ID_   where rt.TASK_DEF_KEY_='createrSubmit' ";
        List backProcInstIds = this.jdbcTemplate.queryForList((String)sql, String.class);
        if (CollectionUtil.isNotEmpty((Collection)backProcInstIds)) {
            sql = "select procInstId,message from  wf_comment where procInstId in (:procInstIds) and type='" + ActionType.REJECTED.name() + "' order by time desc ";
            HashMap<String, HashSet<String>> p = new HashMap<String, HashSet<String>>();
            p.put("procInstIds", procInstIds);
            List comments = this.namedParameterJdbcTemplate.query((String)sql, p, (RowMapper)new BeanPropertyRowMapper(com.elitesland.workflow.entity.Comment.class));
            if (CollectionUtil.isNotEmpty((Collection)comments)) {
                block2: for (String procInstId : procInstIds) {
                    for (com.elitesland.workflow.entity.Comment comment : comments) {
                        if (!comment.getProcInstId().equals(procInstId)) continue;
                        currentTaskInfos.get(procInstId).setBackMessage(comment.getMessage());
                        continue block2;
                    }
                }
            }
        }
        return currentTaskInfos;
    }

    public List<String> getTaskLeaders(String taskId) {
        String sql = "select DISTINCT USER_ID_ from ACT_HI_IDENTITYLINK where TASK_ID_=? and TYPE_ in ('candidate','assignee')";
        return this.jdbcTemplate.queryForList(sql, String.class, new Object[]{taskId});
    }

    public String getPreTaskAssignee(String procInstId, String currentTaskDefKey) {
        String sql = "SELECT ACT_ID_ taskDefKey,ASSIGNEE_ assignee,END_TIME_ endTime FROM ACT_HI_ACTINST WHERE PROC_INST_ID_=? AND ACT_TYPE_='userTask' ORDER BY END_TIME_ IS  NULL,END_TIME_ ASC ";
        List preNodes = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(PreNode.class), new Object[]{procInstId});
        log.info("\u5386\u53f2\u8282\u70b9:{}", (Object)preNodes);
        boolean isContain = false;
        for (PreNode preNode : preNodes) {
            if (!preNode.getTaskDefKey().equals(currentTaskDefKey)) continue;
            isContain = true;
        }
        if (isContain) {
            for (int i = 1; i < preNodes.size(); ++i) {
                if (!currentTaskDefKey.equals(((PreNode)preNodes.get(i)).getTaskDefKey())) continue;
                return ((PreNode)preNodes.get(i - 1)).getAssignee();
            }
        } else {
            return ((PreNode)preNodes.get(preNodes.size() - 1)).getAssignee();
        }
        return null;
    }

    public List<String> queryExecutionId(String procInstId) {
        String sql = "select EXECUTION_ID_ from ACT_RU_TASK where PROC_INST_ID_=?";
        return this.jdbcTemplate.queryForList(sql, String.class, new Object[]{procInstId});
    }

    public String queryRunProcInstId(String procDefKey, String businessKey) {
        try {
            String sql = "select ID_ from ACT_HI_PROCINST where BUSINESS_KEY_=? and PROC_DEF_ID_ like '" + procDefKey + ":%' and END_TIME_ is null";
            return (String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{businessKey});
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<RunTask> queryRunTask(String procInstId) {
        String sql = "select ID_ id,TASK_DEF_KEY_ taskDefKey,ASSIGNEE_ assignee from ACT_RU_TASK where PROC_INST_ID_=?";
        return this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(RunTask.class), new Object[]{procInstId});
    }

    public WorkflowDao(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

