/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.service;

import com.elitesland.workflow.dao.CommentDao;
import com.elitesland.workflow.entity.Comment;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.utils.WorkflowUtils;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CommentService {
    private final CommentDao commentDao;

    public void addComment(String currentUserId, ActionType actionType, String procInstId, String taskId, String taskKey, String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            message = "\u7a7a";
        }
        Comment comment = new Comment();
        comment.setTenantId(WorkflowUtils.getTenantId());
        comment.setTime(LocalDateTime.now());
        comment.setUserId(currentUserId);
        comment.setType(actionType);
        comment.setProcInstId(procInstId);
        comment.setTaskId(taskId);
        comment.setTaskKey(taskKey);
        comment.setMessage(message);
        this.commentDao.add(comment);
    }

    public CommentService(CommentDao commentDao) {
        this.commentDao = commentDao;
    }
}

