/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.service;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.workflow.dao.ProcDefDao;
import com.elitesland.workflow.entity.ProcDef;
import com.elitesland.workflow.enums.ProcDefStatus;
import com.elitesland.workflow.exception.WorkflowException;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ProcDefService {
    private final ProcDefDao procDefDao;

    public long save(ProcDef entity) {
        if (this.procDefDao.exist(entity.getId(), "key", entity.getKey())) {
            throw new WorkflowException("\u6d41\u7a0bkey(" + entity.getKey() + ")\u5df2\u7ecf\u5b58\u5728,\u4e0d\u80fd\u521b\u5efa\u76f8\u540c\u76f8\u540cKEY\u7684\u6d41\u7a0b");
        }
        return this.procDefDao.save(entity, CollectionUtil.newArrayList((Object[])new String[]{"categoryId", "name", "appPrefixUrl"}));
    }

    public long saveXml(ProcDef entity) {
        ProcDef oldEntity = (ProcDef)this.procDefDao.queryById(entity.getId());
        if (oldEntity == null) {
            throw new WorkflowException("\u6d41\u7a0b\u5b9a\u4e49(id:" + entity.getId() + ")\u4e0d\u5b58\u5728");
        }
        entity.setState(oldEntity.getState());
        if (oldEntity.getState() == ProcDefStatus.RUNNING) {
            entity.setState(ProcDefStatus.EDIT);
        }
        return this.procDefDao.save(entity, CollectionUtil.newArrayList((Object[])new String[]{"state", "xml"}));
    }

    public void deleteByIds(List<Long> ids) {
        boolean isDeploy = this.procDefDao.isDeploy(ids);
        if (isDeploy) {
            throw new WorkflowException("\u6d41\u7a0b\u5df2\u7ecf\u90e8\u7f72\u5230\u6d41\u7a0b\u5f15\u64ce\u4e2d,\u4e0d\u80fd\u5220\u9664");
        }
        this.procDefDao.deleteByIds(ids);
    }

    public ProcDefService(ProcDefDao procDefDao) {
        this.procDefDao = procDefDao;
    }
}

