/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.service;

import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.commons.utils.SqlUtils;
import com.elitesland.workflow.exception.WorkflowException;
import com.elitesland.workflow.payload.TaskhandlerPayLoad;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class ProcManageService {
    private static final Logger log = LoggerFactory.getLogger(ProcManageService.class);
    private final JdbcTemplate jdbcTemplate;
    String RUN_TASK_ID_SQL = "(select ID_ from  ACT_RU_TASK)";

    public Map<String, Long> taskInfo(String userId) {
        HashMap<String, Long> info = new HashMap<String, Long>();
        String sql = "select count(1) from ACT_RU_IDENTITYLINK where  TYPE_ in ('assignee') and  USER_ID_=? and TASK_ID_ in " + this.RUN_TASK_ID_SQL;
        info.put("assigneeCount", (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{userId}));
        sql = "select count(1) from ACT_RU_IDENTITYLINK where  TYPE_ in ('candidate') and  USER_ID_=? and TASK_ID_ in " + this.RUN_TASK_ID_SQL;
        info.put("candidateCount", (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{userId}));
        sql = "select count(1) from wf_task_node_config where " + SqlUtils.CONCAT_COMMA("assigneeUserIds") + " like ? ";
        info.put("nodeCount", (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{"%," + userId + ",%"}));
        return info;
    }

    public void resetTaskAssignee(TaskhandlerPayLoad payLoad) {
        Object sql = "update ACT_RU_IDENTITYLINK set USER_ID_=? where  TYPE_ in ('assignee','candidate') and  USER_ID_=? and TASK_ID_ in " + this.RUN_TASK_ID_SQL;
        int num = this.jdbcTemplate.update((String)sql, new Object[]{payLoad.getToUserId(), payLoad.getFromUserId()});
        log.info("ACT_RU_IDENTITYLINK:{}", (Object)num);
        sql = "update ACT_HI_IDENTITYLINK set USER_ID_=?  where  TYPE_ in ('assignee','candidate') and  USER_ID_=? and TASK_ID_ in " + this.RUN_TASK_ID_SQL;
        num = this.jdbcTemplate.update((String)sql, new Object[]{payLoad.getToUserId(), payLoad.getFromUserId()});
        log.info("ACT_HI_IDENTITYLINK:{}", (Object)num);
        sql = "update ACT_RU_TASK  set ASSIGNEE_=? where ASSIGNEE_=?";
        num = this.jdbcTemplate.update((String)sql, new Object[]{payLoad.getToUserId(), payLoad.getFromUserId()});
        log.info("ACT_RU_TASK(ASSIGNEE_):{}", (Object)num);
        sql = "update ACT_RU_TASK  set OWNER_=? where OWNER_=?";
        num = this.jdbcTemplate.update((String)sql, new Object[]{payLoad.getToUserId(), payLoad.getFromUserId()});
        log.info("ACT_RU_TASK(OWNER_):{}", (Object)num);
        sql = "update ACT_HI_TASKINST set ASSIGNEE_=? where ASSIGNEE_=? and END_TIME_ is null";
        num = this.jdbcTemplate.update((String)sql, new Object[]{payLoad.getToUserId(), payLoad.getFromUserId()});
        log.info("ACT_HI_TASKINST:{}", (Object)num);
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                String newAssigneeUserIdsSql = "REPLACE(  " + SqlUtils.CONCAT_COMMA("assigneeUserIds") + "  , " + SqlUtils.CONCAT_COMMA(payLoad.getFromUserId()) + " , " + SqlUtils.CONCAT_COMMA(payLoad.getToUserId()) + ")";
                sql = "update wf_task_node_config set assigneeUserIds=SUBSTRING(" + newAssigneeUserIdsSql + ",2,length(" + newAssigneeUserIdsSql + ")-2 ) where " + SqlUtils.CONCAT_COMMA("assigneeUserIds") + " like ? ";
                num = this.jdbcTemplate.update((String)sql, new Object[]{"%," + payLoad.getFromUserId() + ",%"});
                log.info("wf_task_node_config:{}", (Object)num);
                break;
            }
            case ORACLE: {
                String newAssigneeUserIdsSql = "REPLACE(  " + SqlUtils.CONCAT_COMMA("assigneeUserIds") + "  , " + SqlUtils.CONCAT_COMMA(payLoad.getFromUserId()) + " , " + SqlUtils.CONCAT_COMMA(payLoad.getToUserId()) + ")";
                sql = "update wf_task_node_config set assigneeUserIds=substr(" + newAssigneeUserIdsSql + ",2,length(" + newAssigneeUserIdsSql + ")-2 ) where " + SqlUtils.CONCAT_COMMA("assigneeUserIds") + " like ? ";
                num = this.jdbcTemplate.update((String)sql, new Object[]{"%," + payLoad.getFromUserId() + ",%"});
                log.info("wf_task_node_config:{}", (Object)num);
                break;
            }
            default: {
                throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
            }
        }
    }

    public ProcManageService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

