/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.service;

import com.elitesland.workflow.Constant;
import com.elitesland.workflow.dao.ProcDefDao;
import com.elitesland.workflow.dao.TaskNodeConfigDao;
import com.elitesland.workflow.dao.TaskNodeConfigVariableConditionDao;
import com.elitesland.workflow.dao.UserDao;
import com.elitesland.workflow.dao.WorkflowDao;
import com.elitesland.workflow.domain.TaskNodeVo;
import com.elitesland.workflow.domain.TodoTaskNode;
import com.elitesland.workflow.entity.ProcDef;
import com.elitesland.workflow.entity.TaskNodeConfig;
import com.elitesland.workflow.enums.AssigneeType;
import com.elitesland.workflow.utils.WorkflowUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TaskNodeConfigService {
    private static final Logger log = LoggerFactory.getLogger(TaskNodeConfigService.class);
    private final WorkflowDao workflowDao;
    private final TaskNodeConfigDao taskNodeConfigDao;
    private final TaskNodeConfigVariableConditionDao taskNodeConfigVariableConditionDao;
    private final HistoryService historyService;
    private final ProcDefDao procDefDao;
    private final UserDao userDao;

    public TaskNodeConfig queryByDefKey(String procDefKey, String taskDefId) {
        TaskNodeConfig taskNodeConfig = this.taskNodeConfigDao.query(procDefKey, taskDefId);
        if (taskNodeConfig == null) {
            taskNodeConfig = new TaskNodeConfig();
            taskNodeConfig.setTenantId(WorkflowUtils.getTenantId());
            taskNodeConfig.setProcDefKey(procDefKey);
            taskNodeConfig.setTaskDefId(taskDefId);
            this.taskNodeConfigDao.save(taskNodeConfig);
        }
        taskNodeConfig.setVariableConditionList(this.taskNodeConfigVariableConditionDao.queryList("configId", taskNodeConfig.getId()));
        return taskNodeConfig;
    }

    public TaskNodeVo queryByProcInstId(String procInstId, String currentUserId) {
        Assert.hasText((String)procInstId, (String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a");
        TaskNodeVo taskNodeVo = new TaskNodeVo();
        taskNodeVo.setProcInstId(procInstId);
        taskNodeVo.setCurrentUserId(currentUserId);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstId).singleResult();
        if (historicProcessInstance == null) {
            taskNodeVo.setErrMsg("\u6d41\u7a0b\u5b9e\u4f8bID(" + procInstId + ")\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        } else if (historicProcessInstance.getEndTime() != null) {
            taskNodeVo.setErrMsg("\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f,\u8bf7\u5f00\u53d1\u8bf7\u68c0\u67e5\u4ee3\u7801,\u4f7f\u7528\u5ba1\u6279\u72b6\u6001\u6765\u4f7f<Action>\u7ec4\u4ef6\u4e0d\u663e\u793a!");
        } else {
            String canWithdrawTaskDefKey;
            TaskNodeConfig taskNodeConfig;
            ProcDef procDef = (ProcDef)this.procDefDao.query("key", historicProcessInstance.getProcessDefinitionKey());
            taskNodeVo.setSupportInvalid(procDef.getSupportInvalid());
            List<TodoTaskNode> todoTaskNodes = this.workflowDao.todoTaskIds(procInstId, currentUserId);
            log.info("\u5f53\u524d\u767b\u5f55\u4eba(" + currentUserId + ")\u53ef\u5ba1\u6279\u7684\u4efb\u52a1\u8282\u70b9:" + todoTaskNodes);
            if (CollectionUtils.isNotEmpty(todoTaskNodes)) {
                TodoTaskNode todoTaskNode = todoTaskNodes.get(0);
                taskNodeVo.setTaskId(todoTaskNode.getTaskId());
                taskNodeVo.setTaskDefKey(todoTaskNode.getTaskDefKey());
                taskNodeVo.setFirstTaskNote(Constant.FIRST_TASK_DEF_KEY.equals(todoTaskNode.getTaskDefKey()));
                taskNodeConfig = this.queryByDefKey(todoTaskNode.getProcDefKey(), todoTaskNode.getTaskDefKey());
                taskNodeVo.setSupportRejectedFrom(taskNodeConfig.isSupportRejectedFrom());
                taskNodeVo.setSupportDelegation(taskNodeConfig.isSupportDelegation());
                taskNodeVo.setSupportTransfer(taskNodeConfig.isSupportTransfer());
            }
            if (StringUtils.isBlank((CharSequence)(canWithdrawTaskDefKey = this.workflowDao.canWithdrawTaskDefKey(procInstId, currentUserId))) && historicProcessInstance.getStartUserId().equals(currentUserId)) {
                canWithdrawTaskDefKey = Constant.FIRST_TASK_DEF_KEY;
            }
            taskNodeVo.setWithdrawTaskDefKey(canWithdrawTaskDefKey);
            if (StringUtils.isNotBlank((CharSequence)canWithdrawTaskDefKey)) {
                taskNodeConfig = this.queryByDefKey(historicProcessInstance.getProcessDefinitionKey(), canWithdrawTaskDefKey);
                taskNodeVo.setSupportWithdraw(taskNodeConfig.isSupportWithdraw());
            }
        }
        return taskNodeVo;
    }

    public List<Map<String, String>> taskLeadersTypes() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (AssigneeType assigneeType : AssigneeType.values()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("value", assigneeType.name());
            map.put("label", assigneeType.getDesc());
            list.add(map);
        }
        return list;
    }

    public TaskNodeConfigService(WorkflowDao workflowDao, TaskNodeConfigDao taskNodeConfigDao, TaskNodeConfigVariableConditionDao taskNodeConfigVariableConditionDao, HistoryService historyService, ProcDefDao procDefDao, UserDao userDao) {
        this.workflowDao = workflowDao;
        this.taskNodeConfigDao = taskNodeConfigDao;
        this.taskNodeConfigVariableConditionDao = taskNodeConfigVariableConditionDao;
        this.historyService = historyService;
        this.procDefDao = procDefDao;
        this.userDao = userDao;
    }
}

