/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.elitesland.commons.utils.JwtUtils;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.Constant;
import com.elitesland.workflow.NodeInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.dao.ProcDefDao;
import com.elitesland.workflow.dao.ProcInstDao;
import com.elitesland.workflow.dao.TaskNodeConfigDao;
import com.elitesland.workflow.dao.UserDao;
import com.elitesland.workflow.dao.WorkflowDao;
import com.elitesland.workflow.domain.ActInst;
import com.elitesland.workflow.domain.Comment;
import com.elitesland.workflow.domain.TodoTaskNode;
import com.elitesland.workflow.entity.ProcDef;
import com.elitesland.workflow.entity.ProcInst;
import com.elitesland.workflow.entity.TaskNodeConfig;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.enums.AssigneeType;
import com.elitesland.workflow.enums.ProcDefStatus;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.exception.WorkflowException;
import com.elitesland.workflow.payload.ActivateProcDefPayLoad;
import com.elitesland.workflow.payload.ActivateProcInstPayload;
import com.elitesland.workflow.payload.AddSignPayLoad;
import com.elitesland.workflow.payload.BackPayLoad;
import com.elitesland.workflow.payload.ChangeTaskAssignessPayLoad;
import com.elitesland.workflow.payload.CompletePayLoad;
import com.elitesland.workflow.payload.DelegationPayload;
import com.elitesland.workflow.payload.InterruptProcInstPayLoad;
import com.elitesland.workflow.payload.InvalidProcInstPayload;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TransferPayload;
import com.elitesland.workflow.payload.WithdrawPayLoad;
import com.elitesland.workflow.service.CommentService;
import com.elitesland.workflow.service.TaskNodeConfigService;
import com.elitesland.workflow.utils.WorkflowUtils;
import com.elitesland.workflow.vo.BackNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class WorkflowServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    private final RepositoryService repositoryService;
    private final RuntimeService runtimeService;
    private final TaskService taskService;
    private final HistoryService historyService;
    private final IdentityService identityService;
    private final ManagementService managementService;
    private final WorkflowDao workflowDao;
    private final ProcDefDao procDefDao;
    private final ProcInstDao procInstDao;
    private final UserDao userDao;
    private final CommentService commentService;
    private final WorkflowCallBack workflowCallBack;
    private final TaskNodeConfigService taskNodeConfigService;
    private final TaskNodeConfigDao taskNodeConfigDao;
    private static final String ADD_SIGN_VARIABLE_NAME = "addSign";
    private static final String ADD_SIGN_BEFORE = "before";
    private static final String ADD_SIGN_AFTER = "after";
    @Value(value="${workflow.firstTaskAutoComplete}")
    private Boolean firstTaskAutoComplete;

    @Transactional
    public void deploy(long id) {
        ProcDef procDef = (ProcDef)this.procDefDao.queryById(id);
        if (procDef == null) {
            throw new WorkflowException("\u6d41\u7a0b\u5b9a\u4e49(id:" + id + ")\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)procDef.getXml())) {
            throw new WorkflowException("\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b");
        }
        BpmnModel bpmnModel = WorkflowUtils.getBpmnModel(procDef.getXml());
        Process process = bpmnModel.getMainProcess();
        if (process.findFlowElementsOfType(StartEvent.class).size() != 1) {
            throw new WorkflowException("\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u5f00\u59cb\u8282\u70b9");
        }
        if (process.findFlowElementsOfType(EndEvent.class).size() != 1) {
            throw new WorkflowException("\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u7ed3\u675f\u8282\u70b9");
        }
        if (process.getFlowElement(Constant.FIRST_TASK_DEF_KEY) == null) {
            throw new WorkflowException("\u7b2c\u4e00\u4e2a'\u521b\u5efa\u4eba\u63d0\u4ea4'\u8282\u70b9\u88ab\u4fee\u6539\u8fc7,\u8bf7\u5220\u9664\u6d41\u7a0b,\u91cd\u65b0\u7ed8\u5236\u6d41\u7a0b\u56fe");
        }
        List exclusiveGateways = process.findFlowElementsOfType(ExclusiveGateway.class);
        Collection flowElements = process.getFlowElements();
        for (ExclusiveGateway exclusiveGateway : exclusiveGateways) {
            for (FlowElement flowElement : flowElements) {
                SequenceFlow sequenceFlow;
                if (!(flowElement instanceof SequenceFlow) || !(sequenceFlow = (SequenceFlow)flowElement).getSourceRef().equals(exclusiveGateway.getId()) || !StringUtils.isBlank((CharSequence)sequenceFlow.getConditionExpression())) continue;
                throw new WorkflowException("\u8bf7\u4e3a\u6bcf\u4e2a'\u6392\u4ed6\u7f51\u5173'\u8def\u7ebf\u8bbe\u7f6e\u8868\u8fbe\u5f0f");
            }
        }
        List parallelGateways = process.findFlowElementsOfType(ParallelGateway.class);
        if (CollectionUtils.isNotEmpty((Collection)parallelGateways)) {
            throw new WorkflowException("\u5de5\u4f5c\u6d41\u4e0d\u652f\u6301\u5e76\u884c\u7f51\u5173");
        }
        procDef.setState(ProcDefStatus.RUNNING);
        this.procDefDao.updateById(procDef, CollectionUtil.newArrayList((Object[])new String[]{"state"}));
        Deployment deploy = this.repositoryService.createDeployment().name(procDef.getName()).addString(procDef.getName() + ".bpmn", procDef.getXml()).tenantId(procDef.getTenantId()).deploy();
        log.info("[\u5de5\u4f5c\u6d41]\u90e8\u7f72\u6d41\u7a0b:{}", (Object)deploy);
    }

    @Transactional
    public ProcessInfo startProcess(String processDefinitionKey, String procInstName, String businessKey, HashMap<String, Object> variables) {
        long runCount;
        String currentUserId = WorkflowUtils.getUserId();
        String tenantId = WorkflowUtils.getTenantId();
        Assert.hasText((String)processDefinitionKey, (String)"\u6d41\u7a0bKEY\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)businessKey, (String)"\u4e1a\u52a1KEY\u4e0d\u80fd\u4e3a\u7a7a");
        ProcessDefinitionEntity processDefinition = this.getProcessDefinition(processDefinitionKey, tenantId);
        if (processDefinition.isSuspended()) {
            throw new WorkflowException("\u6d41\u7a0b\u5df2\u7ecf\u88ab\u6302\u8d77,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        Process process = bpmnModel.getMainProcess();
        if (process.findFlowElementsOfType(ExclusiveGateway.class).size() > 0 && (variables == null || variables.isEmpty())) {
            throw new WorkflowException("\u8be5\u6d41\u7a0b\u542b\u6709\u6392\u4ed6\u7f51\u5173,\u542f\u52a8\u6d41\u7a0b\u65f6,\u8bf7\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf");
        }
        List pis = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).processInstanceTenantId(tenantId).list();
        if (CollectionUtils.isNotEmpty((Collection)pis) && (runCount = pis.stream().filter(pi -> pi.getEndTime() == null).count()) > 0L) {
            throw new WorkflowException("\u8be5\u4e1a\u52a1\u5df2\u7ecf\u542f\u52a8\u4e86\u6d41\u7a0b\u4e0d\u80fd\u91cd\u590d\u542f\u52a8");
        }
        if (!this.userDao.existUserId(currentUserId)) {
            throw new WorkflowException("\u7528\u6237(id:" + currentUserId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u53d1\u8d77\u6d41\u7a0b");
        }
        List userTasks = process.findFlowElementsOfType(UserTask.class);
        if (CollectionUtils.isEmpty((Collection)userTasks)) {
            throw new WorkflowException("\u6d41\u7a0b\u56fe\u4e2d\u6ca1\u6709`\u7528\u6237\u4efb\u52a1\u8282\u70b9`,\u8bf7\u8fd4\u56de\u8bbe\u8ba1");
        }
        for (Object userTask : userTasks) {
            if (!(userTask.getBehavior() instanceof ParallelMultiInstanceBehavior) || variables != null && variables.containsKey(userTask.getId())) continue;
            throw new WorkflowException("\u4efb\u52a1(" + userTask.getName() + ")\u4e3a\u4f1a\u7b7e\u8282\u70b9\uff0c\u8bf7\u4f7f\u7528\u6d41\u7a0b\u53d8\u91cf\u8bbe\u7f6e\u5904\u7406\u4eba");
        }
        HashMap<String, String> userTaskNameMap = new HashMap<String, String>();
        for (UserTask userTask : userTasks) {
            if (StringUtils.isBlank((CharSequence)userTask.getName())) {
                throw new WorkflowException("\u6d41\u7a0b\u4e2d\u6709\u8282\u70b9\u672a\u8bbe\u7f6e\u540d\u79f0");
            }
            userTaskNameMap.put(userTask.getId(), userTask.getName());
        }
        List<String> userTaskIds = userTasks.stream().map(BaseElement::getId).collect(Collectors.toList());
        List<TaskNodeConfig> taskNodeConfigs = this.taskNodeConfigDao.query(processDefinitionKey, userTaskIds);
        for (TaskNodeConfig taskNodeConfig : taskNodeConfigs) {
            if (!AssigneeType.VARIABLE.name().equals(taskNodeConfig.getAssigneeType()) || variables != null && variables.containsKey(taskNodeConfig.getTaskDefId())) continue;
            throw new WorkflowException("\u4efb\u52a1(" + (String)userTaskNameMap.get(taskNodeConfig.getTaskDefId()) + ")\u672a\u6d41\u7a0b\u53d8\u91cf\u8bbe\u7f6e\u5904\u7406\u4eba");
        }
        this.identityService.setAuthenticatedUserId(currentUserId);
        ProcessInstance processInstance = this.runtimeService.createProcessInstanceBuilder().processDefinitionKey(processDefinitionKey).businessKey(businessKey).variables(variables).tenantId(tenantId).start();
        ProcInst procInst = new ProcInst();
        procInst.setTenantId(tenantId);
        procInst.setProcInstId(processInstance.getId());
        procInst.setProcInstName(procInstName);
        procInst.setBusinessKey(businessKey);
        procInst.setStatus(ProcInstStatus.APPROVING);
        this.procInstDao.save(procInst);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getProcessInstanceId())).singleResult();
        CompletePayLoad completePayLoad = new CompletePayLoad();
        completePayLoad.setTaskId(task.getId());
        completePayLoad.setComment("\u521b\u5efa\u4eba\u63d0\u4ea4");
        completePayLoad.setFirstNode(true);
        this.complete(completePayLoad, currentUserId);
        log.info("[\u5de5\u4f5c\u6d41]\u542f\u52a8\u6d41\u7a0b,\u4e1a\u52a1KEY{},\u6d41\u7a0b\u5b9e\u4f8b:{}", (Object)businessKey, (Object)processInstance);
        ProcessInfo processInfo = new ProcessInfo();
        String procInstId = processInstance.getId();
        processInfo.setProcInstId(procInstId);
        processInfo.setProcInstStatus(((ProcInst)this.procInstDao.query("procInstId", procInstId)).getStatus());
        return processInfo;
    }

    public void setVariables(String procInstId, HashMap<String, Object> variables) {
        this.getUnSuspendedProcessInstance(procInstId);
        List<String> executionIds = this.workflowDao.queryExecutionId(procInstId);
        for (String executionId : executionIds) {
            this.runtimeService.setVariables(executionId, variables);
        }
    }

    public HashMap<String, TaskInfo> currentTaskInfos(HashSet<String> procInstIds) {
        return this.workflowDao.currentTaskInfos(procInstIds);
    }

    public TaskInfo currentTaskInfo(String procInstId) {
        HashMap<String, TaskInfo> taskInfos = this.currentTaskInfos(CollUtil.newHashSet((Object[])new String[]{procInstId}));
        return taskInfos.get(procInstId);
    }

    public void activateProcessDefinition(ActivateProcDefPayLoad activateProcDefPayLoad) {
        String processDefinitionId = activateProcDefPayLoad.getProcessDefinitionId();
        this.getProcessDefinitionById(processDefinitionId);
        if (activateProcDefPayLoad.getIsSuspended().booleanValue()) {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        } else {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        }
    }

    public void activateProcessInstance(ActivateProcInstPayload activateProcInstPayload) {
        String processInstanceId = activateProcInstPayload.getProcessInstanceId();
        this.getProcessInstance(processInstanceId);
        if (activateProcInstPayload.getIsSuspended().booleanValue()) {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
        } else {
            this.runtimeService.activateProcessInstanceById(processInstanceId);
        }
    }

    @Transactional
    public void interruptProcessInstance(InterruptProcInstPayLoad interruptProcInstPayLoad) {
        String currentUserId = JwtUtils.getUserId();
        String tenantId = WorkflowUtils.getTenantId();
        ProcessInstance processInstance = this.getUnSuspendedProcessInstance(interruptProcInstPayLoad.getProcessInstanceId());
        this.procInstDao.updateStatus(interruptProcInstPayLoad.getProcessInstanceId(), ProcInstStatus.INTERRUPT);
        List currentTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(interruptProcInstPayLoad.getProcessInstanceId())).list();
        for (Task currentTask : currentTasks) {
            this.commentService.addComment(currentUserId, ActionType.INTERRUPT, interruptProcInstPayLoad.getProcessInstanceId(), currentTask.getId(), currentTask.getTaskDefinitionKey(), interruptProcInstPayLoad.getComment());
        }
        this.runtimeService.deleteProcessInstance(interruptProcInstPayLoad.getProcessInstanceId(), interruptProcInstPayLoad.getComment());
        CommentInfo commentInfo = this.workflowDao.queryLastComment(interruptProcInstPayLoad.getProcessInstanceId());
        this.workflowCallBack.processStatusChange(ProcessStatusChangePayload.of((String)tenantId, (String)processInstance.getProcessDefinitionKey(), (ProcInstStatus)ProcInstStatus.INTERRUPT, (String)processInstance.getBusinessKey(), (CommentInfo)commentInfo));
    }

    @Transactional
    public void complete(CompletePayLoad completePayLoad, String currentUserId) {
        Task task = this.getUnSuspendedTask(completePayLoad.getTaskId());
        ActionType actionType = ActionType.AGREE;
        if (Constant.FIRST_TASK_DEF_KEY.equals(task.getTaskDefinitionKey())) {
            actionType = ActionType.SUBMIT;
        }
        if (completePayLoad.isAdmin()) {
            actionType = ActionType.ADMIN_AGREE;
        }
        if (DelegationState.PENDING.equals((Object)task.getDelegationState())) {
            this.taskService.resolveTask(completePayLoad.getTaskId(), completePayLoad.getVariables());
            Task subTask = this.createSubTask(task.getId(), task, currentUserId);
            this.taskService.complete(subTask.getId(), null);
            this.commentService.addComment(currentUserId, actionType, task.getProcessInstanceId(), subTask.getId(), subTask.getTaskDefinitionKey(), completePayLoad.getComment());
        } else {
            this.taskService.setAssignee(completePayLoad.getTaskId(), currentUserId);
            if (StringUtils.isBlank((CharSequence)completePayLoad.getComment())) {
                completePayLoad.setComment("\u540c\u610f");
            }
            this.commentService.addComment(currentUserId, actionType, task.getProcessInstanceId(), completePayLoad.getTaskId(), task.getTaskDefinitionKey(), completePayLoad.getComment());
            this.taskService.complete(completePayLoad.getTaskId(), completePayLoad.getVariables());
            if (!completePayLoad.isFirstNode() || completePayLoad.isFirstNode() && this.firstTaskAutoComplete.booleanValue()) {
                this.againComplete(task, currentUserId);
            }
        }
    }

    private void againComplete(Task task, String currentUserId) {
        if (StringUtils.isNotBlank((CharSequence)task.getExecutionId())) {
            while (true) {
                String procDefKey;
                TaskNodeConfig taskNodeConfig;
                Task nextTask = (Task)((TaskQuery)this.taskService.createTaskQuery().executionId(task.getExecutionId())).active().singleResult();
                log.info("[\u81ea\u52a8\u5b8c\u6210\u4efb\u52a1]\u4e0b\u4e00\u4e2a\u4efb\u52a1:\u4efb\u52a1({})", (Object)nextTask);
                if (nextTask == null || !(taskNodeConfig = this.taskNodeConfigService.queryByDefKey(procDefKey = WorkflowUtils.getProcessDefinitionKey(nextTask.getProcessDefinitionId()), nextTask.getTaskDefinitionKey())).isSupportContinuousComplete()) break;
                List<String> taskRelevantUserIds = this.workflowDao.taskRelevantUserIds(nextTask.getId(), procDefKey);
                log.info("[\u81ea\u52a8\u5b8c\u6210\u4efb\u52a1]\u4e0b\u4e00\u4e2a\u4efb\u52a1\u4efb\u52a1({})\u7684\u76f8\u5173\u4eba\u5458:{}", (Object)nextTask.getId(), taskRelevantUserIds);
                if (!taskRelevantUserIds.contains(currentUserId)) break;
                this.commentService.addComment(currentUserId, ActionType.AUTO_AGREE, nextTask.getProcessInstanceId(), nextTask.getId(), nextTask.getTaskDefinitionKey(), "\u5f53\u524d\u8282\u70b9\u7684\u5ba1\u6279\u4eba\u4e0e\u4e0a\u4e00\u4e2a\u8282\u70b9\u76f8\u540c,\u81ea\u52a8\u5b8c\u6210\u5ba1\u6279");
                this.taskService.setAssignee(nextTask.getId(), currentUserId);
                this.taskService.complete(nextTask.getId());
            }
        }
    }

    public Map<String, Object> procDefBpmn(String processDefinitionId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (InputStream is = this.repositoryService.getProcessModel(processDefinitionId);){
            result.put("xml", IOUtils.toString((InputStream)is, (String)"utf-8"));
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return result;
    }

    public Map<String, Object> procInstBpmn(String processInstanceId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HistoricProcessInstance processInstance = this.getHistoricProcessInstance(processInstanceId);
        try (InputStream is = this.repositoryService.getProcessModel(processInstance.getProcessDefinitionId());){
            result.put("xml", IOUtils.toString((InputStream)is, (String)"utf-8"));
            List<ActInst> actInsts = this.workflowDao.queryActInsts(processInstanceId);
            if (CollectionUtils.isNotEmpty(actInsts)) {
                LinkedHashMap<String, List> executions = new LinkedHashMap<String, List>();
                for (ActInst actInst : actInsts) {
                    if (!executions.containsKey(actInst.getExecutionId())) {
                        executions.put(actInst.getExecutionId(), new ArrayList());
                    }
                    ((List)executions.get(actInst.getExecutionId())).add(actInst);
                }
                for (String executionId : executions.keySet()) {
                    List currentActInsts = (List)executions.get(executionId);
                    String moveToActDefKey = ((ActInst)currentActInsts.get(0)).getMoveToActDefKey();
                    if (!StringUtils.isNotBlank((CharSequence)moveToActDefKey)) continue;
                    ArrayList<ActInst> deletes = new ArrayList<ActInst>();
                    for (ActInst actInst : currentActInsts) {
                        deletes.add(actInst);
                        if (!moveToActDefKey.equals(actInst.getActDefKey())) continue;
                        break;
                    }
                    executions.put(executionId, ListUtils.removeAll((Collection)currentActInsts, deletes));
                }
                ArrayList list = new ArrayList();
                for (List value : executions.values()) {
                    list.addAll(value);
                }
                result.put("actInsts", list);
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return result;
    }

    public void delegation(DelegationPayload delegationPayload) {
        String currentUserId = JwtUtils.getUserId();
        Task task = this.getUnSuspendedTask(delegationPayload.getTaskId());
        if (delegationPayload.getDelegationUserId().equals(currentUserId)) {
            throw new WorkflowException("\u59d4\u6d3e\u4eba\u4e0d\u662f\u81ea\u5df1");
        }
        log.info("\u5f53\u524d\u4efb\u52a1\u7684\u53d7\u8ba9\u4eba:{}", (Object)task.getAssignee());
        if (StringUtils.isBlank((CharSequence)task.getAssignee())) {
            log.info("\u62fe\u53d6\u4efb\u52a1,\u4efb\u52a1({}),\u53d7\u8ba9\u4eba({})", (Object)delegationPayload.getTaskId(), (Object)currentUserId);
            this.taskService.claim(delegationPayload.getTaskId(), currentUserId);
        }
        Task subTask = this.createSubTask(task.getId(), task, currentUserId);
        this.taskService.complete(subTask.getId(), null);
        this.commentService.addComment(currentUserId, ActionType.DELEGATION, task.getProcessInstanceId(), subTask.getId(), subTask.getTaskDefinitionKey(), delegationPayload.getComment());
        this.taskService.delegateTask(delegationPayload.getTaskId(), delegationPayload.getDelegationUserId());
    }

    public void transfer(TransferPayload transferPayload) {
        String currentUserId = JwtUtils.getUserId();
        Task task = this.getUnSuspendedTask(transferPayload.getTaskId());
        if (transferPayload.getTransferUserId().equals(currentUserId)) {
            throw new WorkflowException("\u8f6c\u529e\u4eba\u4e0d\u662f\u81ea\u5df1");
        }
        Task subTask = this.createSubTask(task.getId(), task, currentUserId);
        this.taskService.complete(subTask.getId(), null);
        this.commentService.addComment(currentUserId, ActionType.TRANSFER, task.getProcessInstanceId(), subTask.getId(), subTask.getTaskDefinitionKey(), transferPayload.getComment());
        this.taskService.setAssignee(transferPayload.getTaskId(), transferPayload.getTransferUserId());
    }

    @Transactional
    public void addSign(AddSignPayLoad addSignPayLoad) {
        throw new WorkflowException("\u672a\u5b9e\u73b0");
    }

    @Transactional
    public void withdraw(WithdrawPayLoad withdrawPayLoad) {
        String currentUserId = JwtUtils.getUserId();
        this.getUnSuspendedProcessInstance(withdrawPayLoad.getProcessInstanceId());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().active().processInstanceId(withdrawPayLoad.getProcessInstanceId())).list();
        log.info("\u53ef\u64a4\u56de\u7684\u8282\u70b9:{}", (Object)tasks);
        for (Task task : tasks) {
            if (Constant.FIRST_TASK_DEF_KEY.equals(withdrawPayLoad.getTargetTaskDefKey())) {
                this.procInstDao.updateStatus(withdrawPayLoad.getProcessInstanceId(), ProcInstStatus.NOTSUBMIT);
            }
            this.commentService.addComment(currentUserId, ActionType.REVOKE, withdrawPayLoad.getProcessInstanceId(), task.getId(), task.getTaskDefinitionKey(), withdrawPayLoad.getComment());
            this.runtimeService.createChangeActivityStateBuilder().processInstanceId(withdrawPayLoad.getProcessInstanceId()).moveActivityIdTo(task.getTaskDefinitionKey(), withdrawPayLoad.getTargetTaskDefKey()).changeState();
        }
    }

    @Transactional
    public void back(BackPayLoad backPayLoad, String currentUserId) {
        String targetTaskDefinitionKey = this.workflowDao.getActDefKey(backPayLoad.getTargetActInsId());
        this.getUnSuspendedProcessInstance(backPayLoad.getProcessInstanceId());
        if (Constant.FIRST_TASK_DEF_KEY.equals(targetTaskDefinitionKey)) {
            this.procInstDao.updateStatus(backPayLoad.getProcessInstanceId(), ProcInstStatus.REJECTED);
        }
        this.moveTo(ActionType.REJECTED, currentUserId, backPayLoad.getProcessInstanceId(), targetTaskDefinitionKey, backPayLoad.getComment());
    }

    public void moveTo(ActionType actionType, String currentUserId, String processInstanceId, String targetActDefKey, String comment) {
        this.getUnSuspendedProcessInstance(processInstanceId);
        List currentTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        ArrayList<String> currentTaskDefKeys = new ArrayList<String>();
        log.info("[\u79fb\u52a8\u4efb\u52a1\u8282\u70b9]\u5f53\u524d\u4efb\u52a1:{},\u76ee\u6807\u4efb\u52a1:{}", currentTaskDefKeys, (Object)targetActDefKey);
        for (Task task : currentTasks) {
            currentTaskDefKeys.add(task.getTaskDefinitionKey());
            this.taskService.setAssignee(task.getId(), currentUserId);
            this.commentService.addComment(currentUserId, actionType, processInstanceId, task.getId(), task.getTaskDefinitionKey(), comment);
        }
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstanceId).moveActivityIdsToSingleActivityId(currentTaskDefKeys, targetActDefKey).changeState();
    }

    public List<BackNode> backNodes(String processInstanceId) {
        List<BackNode> backNodes = this.workflowDao.queryBackNodes(processInstanceId);
        List<BackNode> result = new ArrayList<BackNode>();
        HashSet<String> executionIds = new HashSet<String>();
        for (int i = 0; i < backNodes.size(); ++i) {
            BackNode nextBackNode;
            int j;
            BackNode backNode = backNodes.get(i);
            if (backNode.getEndTime() == null) continue;
            if ("userTask".equals(backNode.getActType())) {
                result.add(backNode);
                executionIds.add(backNode.getExecutionId());
                continue;
            }
            if (!"parallelGateway".equals(backNode.getActType())) continue;
            backNode.setActName("\u4f1a\u7b7e\u8282\u70b9");
            int endIndex = i;
            boolean isComplete = false;
            String deleteReason = null;
            String endGatewayParallelDefKey = null;
            for (j = i + 1; j < backNodes.size(); ++j) {
                nextBackNode = backNodes.get(j);
                executionIds.add(nextBackNode.getExecutionId());
                if (deleteReason == null) {
                    endIndex = j;
                    if (StringUtils.isNotBlank((CharSequence)nextBackNode.getDeleteReason())) {
                        deleteReason = nextBackNode.getDeleteReason();
                    }
                } else if (deleteReason.equals(nextBackNode.getDeleteReason())) {
                    endIndex = j;
                    if (backNodes.size() > j + 1 && !executionIds.contains(backNodes.get(j + 1).getExecutionId())) {
                        log.info("--------------->\u4ea7\u751f\u4e86\u65b0\u7684\u6d41\u7a0b\u6267\u884c\u5bf9\u8c61");
                        isComplete = true;
                        break;
                    }
                }
                if (deleteReason != null) continue;
                if (endGatewayParallelDefKey == null) {
                    endIndex = j;
                    if (!"parallelGateway".equals(nextBackNode.getActType())) continue;
                    endGatewayParallelDefKey = nextBackNode.getActDefKey();
                    continue;
                }
                if (!endGatewayParallelDefKey.equals(nextBackNode.getActDefKey())) continue;
                endIndex = j;
                if (backNodes.size() <= j + 1 || !executionIds.contains(backNodes.get(j + 1).getExecutionId())) continue;
                log.info("--------------->\u4e0b\u4e00\u4e2a\u6267\u884c\u5bf9\u8c61\u548c\u5f53\u524d\u6267\u884c\u5bf9\u8c61\u76f8\u540c");
                isComplete = true;
                break;
            }
            if (isComplete) {
                for (j = i + 1; j <= endIndex; ++j) {
                    nextBackNode = backNodes.get(j);
                    if (!StringUtils.isNotBlank((CharSequence)nextBackNode.getUsername())) continue;
                    backNode.getUsernames().add(nextBackNode.getUsername());
                }
                result.add(backNode);
            }
            i = endIndex;
        }
        if (CollectionUtils.isNotEmpty(result)) {
            ArrayList<BackNode> deletes = new ArrayList<BackNode>();
            for (int i = 0; i < result.size() - 1; ++i) {
                BackNode backNode = (BackNode)result.get(i);
                for (int j = i + 1; j < result.size(); ++j) {
                    BackNode nextBackNode = result.get(j);
                    if (!backNode.getActDefKey().equals(nextBackNode.getMoveToActDefKey())) continue;
                    for (int k = i; k <= j; ++k) {
                        deletes.add(result.get(k));
                    }
                    i = j;
                }
            }
            result = ListUtils.removeAll(result, deletes);
        }
        return result;
    }

    @Transactional
    public void changeTaskAssigness(ChangeTaskAssignessPayLoad changeTaskAssignessPayLoad) {
        String currentUserId = JwtUtils.getUserId();
        Task task = this.getUnSuspendedTask(changeTaskAssignessPayLoad.getTaskId());
        this.commentService.addComment(currentUserId, ActionType.CHANGE_TASK_ASSIGNESS, task.getProcessInstanceId(), changeTaskAssignessPayLoad.getTaskId(), task.getTaskDefinitionKey(), changeTaskAssignessPayLoad.getComment());
        this.taskService.setAssignee(changeTaskAssignessPayLoad.getTaskId(), changeTaskAssignessPayLoad.getNewTaskAssigness());
    }

    @Transactional
    public void invalid(InvalidProcInstPayload invalidProcInstPayload) {
        String currentUserId = JwtUtils.getUserId();
        ProcessInstance processInstance = this.getUnSuspendedProcessInstance(invalidProcInstPayload.getProcessInstanceId());
        this.procInstDao.updateStatus(invalidProcInstPayload.getProcessInstanceId(), ProcInstStatus.INVALID);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        Process process = bpmnModel.getMainProcess();
        List endEvents = process.findFlowElementsOfType(EndEvent.class);
        String targetActivityId = ((EndEvent)endEvents.get(0)).getId();
        this.moveTo(ActionType.INVALID, currentUserId, invalidProcInstPayload.getProcessInstanceId(), targetActivityId, invalidProcInstPayload.getComment());
    }

    private ProcessDefinitionEntity getProcessDefinition(String processDefinitionKey, String tenantId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).processDefinitionTenantId(tenantId).latestVersion().singleResult();
        if (processDefinition == null) {
            throw new WorkflowException("\u6d41\u7a0b\u5b9a\u4e49KEY(" + processDefinitionKey + ")\u4e0d\u5b58\u5728");
        }
        return (ProcessDefinitionEntity)processDefinition;
    }

    private ProcessDefinitionEntity getProcessDefinitionById(String processDefinitionId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (processDefinition == null) {
            throw new WorkflowException("\u6d41\u7a0b\u5b9a\u4e49ID(" + processDefinitionId + ")\u4e0d\u5b58\u5728");
        }
        return (ProcessDefinitionEntity)processDefinition;
    }

    public ProcessInstance getProcessInstance(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new WorkflowException("\u6d41\u7a0b\u5b9e\u4f8b(id:" + processInstanceId + ")\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5904\u7406\u5b8c");
        }
        return processInstance;
    }

    private ProcessInstance getUnSuspendedProcessInstance(String processInstanceId) {
        ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance.isSuspended()) {
            throw new WorkflowException("\u6d41\u7a0b\u5df2\u7ecf\u6302\u8d77,\u4e0d\u80fd\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458'\u6fc0\u6d3b'\u6d41\u7a0b");
        }
        return processInstance;
    }

    private HistoricProcessInstance getHistoricProcessInstance(String processInstanceId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new WorkflowException("\u6d41\u7a0b\u5b9e\u4f8b(id:" + processInstanceId + ")\u4e0d\u5b58\u5728");
        }
        return processInstance;
    }

    private Task getUnSuspendedTask(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new WorkflowException("\u4efb\u52a1(id:" + taskId + ")\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5904\u7406\u5b8c\u6210");
        }
        if (task.isSuspended()) {
            throw new WorkflowException("\u6d41\u7a0b\u5df2\u7ecf\u6302\u8d77,\u4e0d\u80fd\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458'\u6fc0\u6d3b'\u6d41\u7a0b");
        }
        return task;
    }

    private HistoricTaskInstance getHistoricTaskInstance(String taskId) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (historicTaskInstance == null) {
            throw new WorkflowException("\u4efb\u52a1(id:" + taskId + ")\u4e0d\u5b58\u5728");
        }
        return historicTaskInstance;
    }

    private Task createSubTask(String rootTaskId, Task parentTask, String assignee) {
        if (parentTask == null) {
            throw new WorkflowException("\u521b\u5efa\u5b50\u4efb\u52a1\u65f6,\u7236\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)assignee)) {
            throw new WorkflowException("\u521b\u5efa\u5b50\u4efb\u52a1\u65f6,\u4efb\u52a1\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TaskEntity subTask = (TaskEntity)this.taskService.newTask();
        subTask.setProcessInstanceId(parentTask.getProcessInstanceId());
        subTask.setProcessDefinitionId(parentTask.getProcessDefinitionId());
        subTask.setName(parentTask.getName());
        subTask.setParentTaskId(rootTaskId);
        subTask.setDescription(parentTask.getDescription());
        subTask.setTaskDefinitionKey(parentTask.getTaskDefinitionKey());
        subTask.setAssignee(assignee);
        subTask.setPriority(parentTask.getPriority());
        subTask.setCreateTime(new Date());
        subTask.setTenantId(parentTask.getTenantId());
        this.taskService.saveTask((Task)subTask);
        List<String> taskLeaders = this.workflowDao.getTaskLeaders(rootTaskId);
        for (String taskLeader : taskLeaders) {
            this.taskService.addCandidateUser(subTask.getId(), taskLeader);
        }
        return subTask;
    }

    public List<String> currentTaskKeys(String procInstId) {
        String currentUserId = JwtUtils.getUserId();
        List<TodoTaskNode> todoTaskNodes = this.workflowDao.todoTaskIds(procInstId, currentUserId);
        if (CollectionUtils.isNotEmpty(todoTaskNodes)) {
            return todoTaskNodes.stream().map(TodoTaskNode::getTaskDefKey).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public ArrayList<CommentInfo> commentInfos(String procInstId) {
        HistoricProcessInstance historicProcessInstance = this.getHistoricProcessInstance(procInstId);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());
        Process process = bpmnModel.getMainProcess();
        List userTasks = process.findFlowElementsOfType(UserTask.class);
        ArrayList<CommentInfo> commentInfos = new ArrayList<CommentInfo>();
        for (UserTask userTask : userTasks) {
            CommentInfo commentInfo = new CommentInfo();
            commentInfo.setTaskName(userTask.getName());
            commentInfo.setTaskDefKey(userTask.getId());
            commentInfos.add(commentInfo);
        }
        Map commentInfoMap = commentInfos.stream().collect(Collectors.toMap(CommentInfo::getTaskDefKey, Function.identity()));
        List<CommentInfo> commentInfoList = this.workflowDao.commentInfos(procInstId);
        for (CommentInfo from : commentInfoList) {
            CommentInfo to = (CommentInfo)commentInfoMap.get(from.getTaskDefKey());
            BeanUtils.copyProperties((Object)from, (Object)to);
        }
        return commentInfos;
    }

    @Transactional
    public void deleteProcess(String procInstId, String comment) {
        String currentUserId = WorkflowUtils.getUserId();
        ProcessInstance processInstance = this.getUnSuspendedProcessInstance(procInstId);
        this.procInstDao.updateStatus(procInstId, ProcInstStatus.DELETE);
        List currentTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).list();
        for (Task currentTask : currentTasks) {
            this.commentService.addComment(currentUserId, ActionType.DELETE, procInstId, currentTask.getId(), currentTask.getTaskDefinitionKey(), comment);
        }
        this.runtimeService.deleteProcessInstance(procInstId, comment);
    }

    public NodeInfo nodeInfo(String procInstId) {
        HistoricProcessInstance historicProcessInstance = this.getHistoricProcessInstance(procInstId);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());
        Process process = bpmnModel.getMainProcess();
        Collection flowElements = process.getFlowElements();
        NodeInfo nodeInfo = new NodeInfo();
        ArrayList<Object> nodeList = new ArrayList<Object>();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask) && !(flowElement instanceof EndEvent)) continue;
            NodeInfo.Node node2 = new NodeInfo.Node();
            node2.setNodeKey(flowElement.getId());
            node2.setNodeName(flowElement.getName());
            if (flowElement instanceof EndEvent) {
                node2.setNodeName("\u5ba1\u6279\u5b8c\u6210");
                node2.setLastOptTime(LocalDateTimeUtil.of((Date)historicProcessInstance.getEndTime()));
            }
            nodeList.add(node2);
        }
        List<Comment> comments = this.workflowDao.comments(procInstId);
        if (CollectionUtils.isNotEmpty(comments)) {
            Map nodeMap = nodeList.stream().collect(Collectors.toMap(NodeInfo.Node::getNodeKey, Function.identity()));
            for (Comment comment : comments) {
                if (!nodeMap.containsKey(comment.getTaskKey())) continue;
                NodeInfo.Node node3 = (NodeInfo.Node)nodeMap.get(comment.getTaskKey());
                node3.setLastOptUserName(comment.getUserName());
                node3.setLastOptTime(LocalDateTimeUtil.of((Date)comment.getTime()));
            }
        }
        if (historicProcessInstance.getEndTime() != null) {
            nodeInfo.setCurrentNodeIndex(Integer.valueOf(Integer.MAX_VALUE));
        } else if (CollectionUtils.isNotEmpty(comments)) {
            String lastTaskKey = null;
            for (Comment comment : comments) {
                if (!StringUtils.isNotBlank((CharSequence)comment.getTaskKey())) continue;
                lastTaskKey = comment.getTaskKey();
            }
            List nodeKeyList = nodeList.stream().map(node -> node.getNodeKey()).collect(Collectors.toList());
            nodeInfo.setCurrentNodeIndex(Integer.valueOf(nodeKeyList.indexOf(lastTaskKey)));
        } else {
            nodeInfo.setCurrentNodeIndex(Integer.valueOf(0));
        }
        nodeInfo.setNodes(nodeList);
        return nodeInfo;
    }

    public WorkflowServiceImpl(RepositoryService repositoryService, RuntimeService runtimeService, TaskService taskService, HistoryService historyService, IdentityService identityService, ManagementService managementService, WorkflowDao workflowDao, ProcDefDao procDefDao, ProcInstDao procInstDao, UserDao userDao, CommentService commentService, WorkflowCallBack workflowCallBack, TaskNodeConfigService taskNodeConfigService, TaskNodeConfigDao taskNodeConfigDao) {
        this.repositoryService = repositoryService;
        this.runtimeService = runtimeService;
        this.taskService = taskService;
        this.historyService = historyService;
        this.identityService = identityService;
        this.managementService = managementService;
        this.workflowDao = workflowDao;
        this.procDefDao = procDefDao;
        this.procInstDao = procInstDao;
        this.userDao = userDao;
        this.commentService = commentService;
        this.workflowCallBack = workflowCallBack;
        this.taskNodeConfigService = taskNodeConfigService;
        this.taskNodeConfigDao = taskNodeConfigDao;
    }
}

