/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.workflow.utils;

import com.elitesland.commons.utils.JwtUtils;
import com.elitesland.commons.utils.SpringUtils;
import com.elitesland.commons.utils.SqlUtils;
import com.elitesland.workflow.exception.WorkflowException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;

public class WorkflowUtils {
    private static final String CANDIDATE = " 'assignee','candidate' ";

    public static BpmnModel getBpmnModel(String xml) {
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(xml.getBytes()), "UTF-8");
            XMLStreamReader xtr = XMLInputFactory.newInstance().createXMLStreamReader(in);
            return new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            throw new WorkflowException("\u6d41\u7a0b\u56fexml\u8bfb\u53d6\u6709\u8bef");
        }
    }

    public static String getProcessDefinitionKey(String processDefinitionId) {
        ProcessDefinition processDefinition = (ProcessDefinition)SpringUtils.getBean(RepositoryService.class).createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (processDefinition == null) {
            throw new WorkflowException("\u6d41\u7a0b\u5b9a\u4e49ID(" + processDefinitionId + ")\u4e0d\u5b58\u5728");
        }
        return processDefinition.getKey();
    }

    public static String getProcessDefinitionKeyByProcessInstanceId(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)SpringUtils.getBean(RuntimeService.class).createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new WorkflowException("\u6d41\u7a0b\u5b9e\u4f8bID(" + processInstanceId + ")\u4e0d\u5b58\u5728");
        }
        return processInstance.getProcessDefinitionKey();
    }

    public static String taskLeaderSql(String column, String alias) {
        return " (SELECT " + SqlUtils.GROUP_CONCAT(column) + " from " + WorkflowUtils.getUserTable() + " where id IN (select USER_ID_ from ACT_HI_IDENTITYLINK where TYPE_ in ( 'assignee','candidate' ) and TASK_ID_=task.ID_) )" + alias + " ";
    }

    public static String taskLeaderSql(String alias) {
        return WorkflowUtils.taskLeaderSql("last_name", alias);
    }

    public static String taskHandlerSql(String alias) {
        return "(SELECT " + SqlUtils.GROUP_CONCAT("last_name") + " from " + WorkflowUtils.getUserTable() + " where id = task.ASSIGNEE_) " + alias + " ";
    }

    public static String isTaskHandlerSql(String currentUserId) {
        return "(      (task.ASSIGNEE_ IS NOT NULL  and  task.ASSIGNEE_ ='" + currentUserId + "')   or    (      task.ASSIGNEE_ IS NULL        and       (select count(1) from ACT_HI_IDENTITYLINK  where  TASK_ID_= task.ID_ and TYPE_ in ( 'assignee','candidate' )  and  USER_ID_='" + currentUserId + "' )>0    ) )";
    }

    public static String isTaskAgentSql(String currentUserId) {
        return "   (      (       select            count(1)        from wf_agent agent       where " + WorkflowUtils.taskAgentWhereSql() + "           and           " + SqlUtils.CONCAT_COMMA("agent.agentUserIds") + " like " + currentUserId + "       )>0    )";
    }

    public static String taskAgentSql(String alias) {
        switch (SpringUtils.getDBType()) {
            case MySQL: {
                return "( SELECT " + SqlUtils.GROUP_CONCAT("last_name") + " from " + WorkflowUtils.getUserTable() + " where id IN     (       select            substring_index( substring_index(agent.agentUserIds,',',topic.help_topic_id + 1) ,',',-1)         from wf_agent agent        JOIN mysql.help_topic topic ON topic.help_topic_id < ( length(agent.agentUserIds) - length(REPLACE(agent.agentUserIds, ',', '')) + 1 )        where " + WorkflowUtils.taskAgentWhereSql() + "   )) " + alias + " ";
            }
        }
        throw new WorkflowException("\u672a\u5bf9\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b(" + SpringUtils.getDBType() + ")\u8fdb\u884c\u5904\u7406");
    }

    private static String taskAgentWhereSql() {
        return "           agent.procDefKey=pd.KEY_           and            (agent.startTime is null or agent.startTime<=" + SqlUtils.getCurrentDate() + " )            and            (agent.endTime is null or agent.endTime>=" + SqlUtils.getCurrentDate() + " )            and            (               (task.ASSIGNEE_ IS NOT NULL and agent.userId=task.ASSIGNEE_)               or               (task.ASSIGNEE_ IS NULL     and agent.userId in (select USER_ID_ from ACT_HI_IDENTITYLINK where TYPE_ in ( 'assignee','candidate' ) and TASK_ID_=task.ID_))           )";
    }

    public static String getTenantId() {
        if (!SpringUtils.hasTenant()) {
            return "1";
        }
        String tenantId = null;
        try {
            if (StringUtils.isBlank(tenantId)) {
                tenantId = SpringUtils.getRequest().getHeader("X-Tenant-Id");
                System.out.println("\u8bf7\u6c42\u5934\u7684X-Tenant-Id\u83b7\u53d6\u7684\u79df\u6237ID:" + tenantId);
            }
            if (StringUtils.isBlank((CharSequence)tenantId)) {
                tenantId = JwtUtils.getTenantId();
                System.out.println("\u8bf7\u6c42\u5934\u4e0a\u83b7\u53d6\u7684\u79df\u6237ID:" + tenantId);
            }
        }
        catch (Exception e) {
            tenantId = "0";
        }
        return tenantId;
    }

    public static String getUserId() {
        String userId = null;
        if (StringUtils.isBlank(userId)) {
            try {
                userId = JwtUtils.getUserId();
                System.out.println("\u8bf7\u6c42\u5934\u4e2d\u83b7\u53d6\u7684\u7528\u6237ID:" + userId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isBlank(userId)) {
            throw new WorkflowException("\u83b7\u53d6\u7528\u6237ID\u5931\u8d25");
        }
        return userId;
    }

    public static String getUserTable() {
        return SpringUtils.getSystemDBName() + "sys_user";
    }

    public static String getTenantUserTable() {
        return SpringUtils.getSystemDBName() + "sys_tenant_user";
    }

    public static String handUserTable(String sql) {
        return sql.replaceAll(" sys_user ", " " + WorkflowUtils.getUserTable() + " ");
    }
}

