package com.elitesland.yst.ai.lowcode.rpc.param;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 租户申购相关信息
 * @author Michael
 */
@Data
@Accessors(chain = true)
public class YstTenantPurchaseDTO implements Serializable {
    private static final long serialVersionUID = 5921203520948727760L;

    /**
     * ID
     */
    private Long id;

    /**
     * 租户编码
     */
    private String tenantCode;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 联系人
     */
    private String contact;

    /**
     * 联系电话
     */
    private String contactNumber;

    /**
     * 职位
     */
    private String jobTitle;

    /**
     * 需求
     */
    private String demand;

    /**
     * 申请时间
     */
    private LocalDateTime applicationTime;

    /**
     * 处理状态 1=待处理，2=已处理
     */
    private Integer processingStatus;

    /**
     * 处理意见，使用udc编码
     */
    private String processingOpinion;

    /**
     * 处理备注
     */
    private String processingRemark;

    /**
     * 处理时间
     */
    private LocalDateTime processingTime;

}
