package com.elitesland.yst.ai.lowcode.constant;
/**
 * 租户申购枚举类
 * @author Michael
 */
public enum TenantPurchaseEnum {
    ;
    /**
     * 处理意见 UDC翻译
     */
    public enum Opinion{
        /**
         * 授权
         */
        APP_TENANT_AUTH,
        /**
         * 不授权
         */
        APP_TENANT_UNAUTH,
        /**
         * 待定
         */
        APP_TENANT_PENDING
    }

    /**
     * 租户处理状态
     */
    public enum TPStatus{
        /**
         * 待处理
         */
        TO_BE_PROCESSED(1),
        /**
         * 已处理
         */
        PROCESSED(2);

        private final Integer code;

        TPStatus(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

    public enum TPSource{
        /**
         * (租户申购列表)新增
         */
        BUTTON_SAVE(1),
        /**
         * (应用市场申购弹窗)新增
         */
        MARKET_POPUP_SAVE(2);

        private final Integer code;

        TPSource(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }
}
