package com.elitesland.yst.ai.rpc.cacheable.impl;

import com.elitescloud.boot.common.annotation.CloudtCache;
import com.elitescloud.boot.common.annotation.CloudtCacheMethod;
import com.elitescloud.boot.core.support.cache.common.AbstractCacheableService;
import com.elitesland.yst.ai.Application;
import com.elitesland.yst.ai.rpc.DemoRpcService;
import com.elitesland.yst.ai.rpc.cacheable.CacheDemoRpcService;
import com.elitesland.yst.ai.rpc.param.YstDemoDTO;
import com.mysema.commons.lang.Assert;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 缓存服务的实现类.
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/10
 */
@CloudtCache(type = "测试", name = "示例数据")
@Component
public class CacheDemoRpcServiceImpl extends AbstractCacheableService implements CacheDemoRpcService {

    @NotBlank
    @Override
    public String appCode() {
        return Application.NAME;
    }

    @NotBlank
    @Override
    public String code() {
        return "demo";
    }

    @CloudtCacheMethod(name = "根据编码获取示例数据")
    @Override
    public YstDemoDTO getByCode(String code) {
        Assert.hasText(code, "编码为空");

        return super.getService(DemoRpcService.class).getByCode(code).computeData();
    }
}
