package com.elitesland.yst.ai.lowcode.constant;

/**
 * 应用信息
 * @author Michael
 */
public enum AppInfoEnum {
    ;

    /**
     * 应用类型
     */
    public enum Type{
        /**
         * 系统应用
         */
        SYSTEM_APPLICATION(1),
        /**
         * 业务应用
         */
        BUSINESS_APPLICATION(2);

        private final Integer code;

        Type(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

    /**
     * 应用组别 UDC翻译
     */
    public enum Group{
        /**
         * 通用
         */
        APP_GENERALITY,
        /**
         * 销售
         */
        APP_SALE,
        /**
         * 生产
         */
        APP_PRODUCTION,
        /**
         * 采购
         */
        APP_PROCUREMENT,
        /**
         * 仓储
         */
        APP_WAREHOUSING,
        /**
         * 质量
         */
        APP_QUALITY,
        /**
         * 财务
         */
        APP_FINANCE,
        /**
         * 人力资源
         */
        APP_HUMAN_RESOURCES,
        /**
         * 市场营销
         */
        APP_MARKETING,
        /**
         * 安全
         */
        APP_SECURITY,
        /**
         * 其它
         */
        APP_OTHER;
    }

    /**
     * 状态 UDC翻译
     */
    public enum Status{
        /**
         * 准备中
         */
        APP_PREPARING,
        /**
         * 待上架
         */
        APP_TO_BE_SHELVED,
        /**
         * 已上架
         */
        APP_ON_SHELVES,
        /**
         * 已下架
         */
        APP_OFF_SHELVES
    }

    /**
     * 流程节点
     */
    public enum PNode{
        /**
         * 准备中
         */
        PREPARING(1),
        /**
         * 准备中->待上架
         */
        TO_BE_EDITED(2),
        /**
         * 准备中->待上架->已上架
         */
        EDITED(3);

        private final Integer code;

        PNode(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

    /**
     * 上一次操作
     */
    public enum LAction{
        /**
         * 新增
         */
        NEW("新增"),
        /**
         * 就绪
         */
        READY("就绪"),
        /**
         * 上架
         */
        ON_SHELVES("上架"),
        /**
         * 下架
         */
        OFF_SHELVES("下架");

        private final String msg;

        LAction(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return msg;
        }
    }
}
