package com.elitesland.yst.ai.lowcode.constant;

/**
 *
 * @author Michael
 * @date 2023/7/17 9:58
 */
public enum GlobalStockEnum {
    ;

    /**
     * 库存状态
     */
    public enum WarehouseStatus{
        /**
         * 冻结
         */
        FREEZE(0),
        /**
         * 正常
         */
        NORMAL(1);

        public Integer getCode() {
            return code;
        }

        private final Integer code;

        WarehouseStatus(Integer code) {
            this.code = code;
        }
    }

    /**
     * 供应商状态
     */
    public enum SupplierStatus{
        /**
         * 冻结
         */
        FREEZE(0),
        /**
         * 正常
         */
        NORMAL(1);

        public Integer getCode() {
            return code;
        }

        private final Integer code;

        SupplierStatus(Integer code) {
            this.code = code;
        }
    }

    /**
     * 供货类型
     */
    public enum SupplyType{
        /**
         * 内部可用
         */
        APP_A("内部可用"),
        /**
         * 经销商寄售
         */
        APP_B("经销商寄售"),
        /**
         * 供应商备货
         */
        APP_C("供应商备货");

        public String getMsg() {
            return msg;
        }

        private final String msg;

        SupplyType(String msg) {
            this.msg = msg;
        }
    }
}
