package com.elitesland.yst.ai.lowcode.constant;
/**
 * 工作流
 * @author Michael
 */
public enum WorkFlow {
    ;
    /**
     * 流程定义key
     */
    public enum ProcDefKey {
        /**
         * 全局库存
         */
        STOCK;
    }

    /**
     * 任务节点key
     */
    public enum TaskKey{
        /**
         * 全局库存
         */
        Activity_0wf2mqs,
        /**
         *
         */
        Activity_071dmkt;
    }

    /**
     * 指定角色
     */
    public enum Role{
        /**
         * 调拨员
         */
        DB001,
        /**
         * 采购元
         */
        CG001,
        /**
         * 采购员
         */
        CK001;
    }

    /**
     * 库存单据状态
     */
    public enum StockStatus{
        /**
         * 草稿
         */
        DRAFT("草稿"),
        /**
         * 已拒绝
         */
        REJECTED("已拒绝"),
        /**
         * 审批中
         */
        APPROVING("审批中"),
        /**
         * 作废
         */
        INVALID("作废"),
        /**
         * 完成
         */
        APPROVED("完成");

        public final String value;

        StockStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }
}
