package com.elitesland.yst.ai.lowcode.rpc.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 应用市场
 * @author bill
 */
@Data
@ApiModel(description = "应用市场数据")
public class AppMarketDTO implements Serializable {

    private static final long serialVersionUID = -6096713949150555824L;
    /**
     * 应用主键
     */
    @ApiModelProperty(value = "应用主键")
    private Long appId;

    /**
     * 应用名称
     */
    @ApiModelProperty(value = "应用名称")
    private String appName;

    /**
     * 应用状态
     */
    @ApiModelProperty(value = "应用状态")
    private String status;

    /**
     * 状态名称
     */
    @ApiModelProperty(value = "状态名称")
    private String statusName;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码")
    private String appCode;

    /**
     * 应用详情主键
     */
    @ApiModelProperty(value = "应用详情主键")
    private Long appDetailId;

    /**
     * 订阅表主键
     */
    @ApiModelProperty(value = "订阅表主键")
    private Long subId;

    /**
     * logo
     */
    @ApiModelProperty(value = "logo图标")
    private String logo;

}
