package com.elitesland.yst.ai.lowcode.constant;

/**
 * 应用市场执行枚举类
 * @author bill
 */
public enum AppMarketEnum {

    /**
     * 系统管理员市场模糊查询执行
     */
    SYSTEM_ADMIN("systemAdminAppMarketExecutor"),
    /**
     * 租户管理员市场模糊查询执行
     */
    TENANT_ADMIN("tenantAdminAppMarketExecutor"),
    /**
     * 租户用户市场模糊查询执行
     */
    TENANT_USER("tenantUserAppMarketExecutor"),
    /**
     * 租户用户订阅市场模糊查询执行
     */
    TENANT_USER_SUB("tenantUserSubAppMarketExecutor"),
    /**
     * 系统管理员市场列表模糊查询执行
     */
    GROUP_SYSTEM_ADMIN("systemAdminAppMarketGroupExecutor"),
    /**
     * 租户管理员市场列表模糊查询执行
     */
    GROUP_TENANT_ADMIN("tenantAdminAppMarketGroupExecutor"),
    /**
     * 租户用户市场列表模糊查询执行
     */
    GROUP_TENANT_USER("tenantUserAppMarketGroupExecutor"),
    /**
     * 租户用户订阅市场列表模糊查询执行
     */
    GROUP_TENANT_USER_SUB("tenantUserSubAppMarketGroupExecutor");



    AppMarketEnum(String name){
        this.name = name;
    }

    private String name;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
