package com.elitesland.yst.ai.lowcode.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
/**
 * 历史记录数据
 * @author Michael
 */
@Data
@ApiModel(description = "历史记录数据")
public class HistoryRecordInsertDTO implements Serializable {

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    private Long id;

    /**
     * 订单号
     */
    @ApiModelProperty(value = "订单号")
    private String orderNo;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String cargoCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称")
    private String cargoName;

    /**
     * 产品规格
     */
    @ApiModelProperty(value = "产品规格")
    private String cargoSpecification;

    /**
     * 需求时间
     */
    @ApiModelProperty(value = "需求时间")
    private LocalDateTime demandTime;

    /**
     * 供货类型
     */
    @ApiModelProperty(value = "供货类型")
    private String supplyType;

    /**
     * 供货组织编码
     */
    @ApiModelProperty(value = "供货组织编码")
    private String supplyOrgCode;

    /**
     * 供货组织名称
     */
    @ApiModelProperty(value = "供货组织名称")
    private String supplyOrgName;

    /**
     * 供货数量
     */
    @ApiModelProperty(value = "供货数量")
    private Integer supplyQuantity;

    /**
     * 单位
     */
    @ApiModelProperty(value = "单位")
    private String unit;
}
