package com.elitesland.yst.ai.lowcode.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
/**
 * 订单信息数据
 * @author Michael
 */
@Data
@ApiModel(description = "订单信息数据")
public class OrderInfoInsertDTO implements Serializable {
    private static final long serialVersionUID = -3954697325467743435L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    private Long id;

    /**
     * 订单号
     */
    @ApiModelProperty(value = "订单号")
    private String orderNo;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String customerName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String cargoCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称")
    private String cargoName;

    /**
     * 产品规格
     */
    @ApiModelProperty(value = "产品规格")
    private String cargoSpecification;

    /**
     * 需求时间
     */
    @ApiModelProperty(value = "需求时间")
    private LocalDateTime demandTime;

    /**
     * 需求数量
     */
    @ApiModelProperty(value = "需求数量")
    private Integer demandQuantity;

    /**
     * 单位
     */
    @ApiModelProperty(value = "单位")
    private String unit;

    /**
     * 状态
     */
    @ApiModelProperty(value = "状态 0=待处理，1=已处理")
    private Integer status;

}
