package com.elitesland.yst.ai.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.ai.Application;
import com.elitesland.yst.ai.rpc.param.YstDemoDTO;
import com.elitesland.yst.ai.rpc.param.query.YstDemoQueryDTO;
import com.elitesland.yst.ai.rpc.param.save.YstDemoInsertDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * DEMO服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@FeignClient(name = Application.NAME, path = DemoRpcService.URI)
@Validated
public interface DemoRpcService {
    String URI = Application.URI_PREFIX + "/demo";

    /**
     * 是否已就绪
     *
     * @return 是否已就绪
     */
    @GetMapping(value = "/isReady")
    ApiResult<Boolean> isReady();

    /**
     * 新增数据
     *
     * @param insertDTO 新增数据信息
     * @return 数据ID
     */
    @PostMapping(value = "/add")
    ApiResult<Long> add(@RequestBody @Valid YstDemoInsertDTO insertDTO);

    /**
     * 根据编码获取
     *
     * @param code 编码
     * @return 数据
     */
    @GetMapping(value = "/getByCode")
    ApiResult<YstDemoDTO> getByCode(@RequestParam(name = "code") String code);

    /**
     * 查询DEMO数据
     *
     * @param queryDTO 查询参数
     * @return 查询结果
     */
    @PostMapping(value = "/query")
    ApiResult<List<YstDemoDTO>> query(@RequestBody YstDemoQueryDTO queryDTO);
}
