package com.elitesland.yst.ai.lowcode.rpc.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author bill
 */
@Data
@ApiModel(description = "自定义配置数据")
public class CustomConfigurationDTO implements Serializable {

    private static final long serialVersionUID = -6647378877382706790L;
    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    private Long id;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")
    private String userName;

    /**
     * 角色编码
     */
    @ApiModelProperty(value = "角色编码")
    private String roleCode;

    /**
     * 自定义配置JSON串
     */
    @ApiModelProperty(value = "自定义配置JSON串")
    private String configuration;

    /**
     * 类型区分
     */
    @ApiModelProperty(value = "类型编码")
    private String type;

    /**
     * 是否可编辑
     */
    @ApiModelProperty(value = "是否可编辑")
    private Integer updateStatus;

    /**
     * 用户主键
     */
    @ApiModelProperty(value = "用户主键")
    private Long userId;

    /**
     * 角色主键
     */
    @ApiModelProperty(value = "角色主键")
    private Long roleId;
}
