package com.elitesland.yst.ai.lowcode.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
/**
 * 全局库存信息数据
 * @author Michael
 */
@Data
@ApiModel(description = "全局库存信息数据")
public class GlobalStockInsertDTO implements Serializable {
    private static final long serialVersionUID = 9206184548163362429L;

    /**
     * 库存组织编码
     */
    @ApiModelProperty(value = "库存组织编码")
    private String invOrgCode;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码")
    private String cargoCode;

    /**
     * 计划数量
     */
    @ApiModelProperty(value = "可用数量")
    private Integer planQuantity;
}
