package com.elitesland.yst.emdg.common.model.dto;

import com.elitesland.yst.emdg.common.model.*;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Builder
@Accessors(chain = true)
public class BizOptLogDTO implements Serializable {

    @Serial
    private static final long serialVersionUID = 8322978393929702192L;

    // --核心标识字段
    // 记录唯一ID
    private long id;

    // Trace ID
    private String traceId;

    // -- 基础信息字段
    // 业务域编号
    private EmdgBizLogDomainEnum domain;

    // 业务服务名称
    private String serviceName;

    // 日志类型，用户操作，系统接口，外部HTTP接口，RPC接口，其他
    private EmdgBizLogTypeEnum logType;

    // 操作类型，创建，更新，删除，查询，导出，导入，其他
    private EmdgBizLogActionEnum action;

    // 操作人，用户，服务，系统，其他
    private String operator;

    // 用户调用，服务内部调用，系统域调用
    private EmdgBizLogOperatorEnum operatorType;

    // -- 请求信息
    // 客户端IP
    private String clientIp;

    // HTTP请求方式, GET, POST, PUT, DELETE, RPC, 其他
    private EmdgBizLogReqMethodEnum requestType;

    // HTTP或RPC请求地址
    private String requestUrl;

    // HTTP请求头
    private String requestHeader;

    // 调用发送的业务数据，用于所有的调用入参数据
    private String requestBody;

    // -- 响应信息
    // HTTP响应的状态码
    private String respStatusCode;

    // HTTP响应头
    private String respHeader;

    // 调用返回的业务数据，用于所有的调用返回数据
    private String respBody;

    // -- 调用状态和时间
    // 调用是否成功，true/false
    private boolean success;

    // 调用开始时间
    private LocalDateTime startTime;

    // 调用结束时间
    private LocalDateTime endTime;

    // 调用耗时，单位毫秒
    private long costTime;

    // -- 异常信息
    // 调用异常编码，业务异常编码，系统异常编码，其他
    private EmdgBizLogErrorEnum errorCode;

    // 调用异常堆栈信息
    private String exceptionStack;

    // 日志时间
    private LocalDateTime logTime;
}
