package com.elitesland.yst.emdg.common.service;

import com.elitesland.yst.emdg.common.model.EmdgBizLogActionEnum;
import com.elitesland.yst.emdg.common.model.EmdgBizLogDomainEnum;
import com.elitesland.yst.emdg.common.model.EmdgBizLogErrorEnum;
import com.elitesland.yst.emdg.common.model.EmdgBizLogReqMethodEnum;

import java.time.LocalDateTime;

public interface EmdgBizOptLogService {

    // 正常业务日志记录

    // 用户调用日志
    void userActionInfo(EmdgBizLogDomainEnum domain,
                        String serviceName,
                        EmdgBizLogActionEnum action,
                        Object reqBody,
                        Object respBody,
                        LocalDateTime startTime,
                        LocalDateTime endTime);

    // 服务调用日志
    void serviceActionInfo(EmdgBizLogDomainEnum domain,
                           String serviceName,
                           EmdgBizLogActionEnum action,
                           Object reqBody,
                           Object respBody,
                           LocalDateTime startTime,
                           LocalDateTime endTime);

    // 工作流调用日志
    void workflowInfo(EmdgBizLogDomainEnum domain,
                      String serviceName,
                      EmdgBizLogActionEnum action,
                      Object reqBody,
                      Object respBody,
                      LocalDateTime startTime,
                      LocalDateTime endTime);

    // RPC调用日志
    void rpcActionInfo(EmdgBizLogDomainEnum domain,
                       String serviceName,
                       EmdgBizLogActionEnum action,
                       String rpcUri,
                       Object reqBody,
                       Object respBody,
                       LocalDateTime startTime,
                       LocalDateTime endTime);

    // 外部HTTP接口调用日志
    void httpApiInfo(EmdgBizLogDomainEnum domain,
                     String serviceName,
                     EmdgBizLogActionEnum action,
                     EmdgBizLogReqMethodEnum methodType,
                     String httpUrl,
                     Object httpHeader,
                     Object reqBody,
                     String statusCode,
                     Object respHeader,
                     Object respBody,
                     LocalDateTime startTime,
                     LocalDateTime endTime);

    // 用户调用错误日志
    void userActionError(EmdgBizLogDomainEnum domain,
                         String serviceName,
                         EmdgBizLogActionEnum action,
                         Object reqBody,
                         Object respBody,
                         EmdgBizLogErrorEnum errorCode,
                         Object exceptionStack,
                         LocalDateTime startTime,
                         LocalDateTime endTime);

    // 服务调用错误日志
    void serviceActionError(EmdgBizLogDomainEnum domain,
                            String serviceName,
                            EmdgBizLogActionEnum action,
                            Object reqBody,
                            Object respBody,
                            EmdgBizLogErrorEnum errorCode,
                            Object exceptionStack,
                            LocalDateTime startTime,
                            LocalDateTime endTime);

    // 工作流调用错误日志
    void workflowError(EmdgBizLogDomainEnum domain,
                       String serviceName,
                       EmdgBizLogActionEnum action,
                       Object reqBody,
                       Object respBody,
                       EmdgBizLogErrorEnum errorCode,
                       Object exceptionStack,
                       LocalDateTime startTime,
                       LocalDateTime endTime);

    // RPC调用错误日志
    void rpcActionError(EmdgBizLogDomainEnum domain,
                        String serviceName,
                        EmdgBizLogActionEnum action,
                        String rpcUri,
                        Object reqBody,
                        Object respBody,
                        EmdgBizLogErrorEnum errorCode,
                        Object exceptionStack,
                        LocalDateTime startTime,
                        LocalDateTime endTime);

    // 外部HTTP接口调用错误日志
    void httpApiError(EmdgBizLogDomainEnum domain,
                      String serviceName,
                      EmdgBizLogActionEnum action,
                      EmdgBizLogReqMethodEnum methodType,
                      String httpUrl,
                      Object httpHeader,
                      Object reqBody,
                      String statusCode,
                      Object respHeader,
                      Object respBody,
                      EmdgBizLogErrorEnum errorCode,
                      Object exceptionStack,
                      LocalDateTime startTime,
                      LocalDateTime endTime);
}
