package com.elitesland.yst.emdg.common.model.dto;

import com.elitesland.yst.emdg.common.model.*;
import com.querydsl.sql.Column;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;
import org.jdbi.v3.core.mapper.reflect.ColumnName;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class BizOptLogDTO implements Serializable {

    @Serial
    private static final long serialVersionUID = 8322978393929702192L;

    public BizOptLogDTO() {
    }

    // --核心标识字段
    // 记录唯一ID
    private long id;

    // Trace ID
    @ColumnName("trace_id")
    private String traceId;

    // -- 基础信息字段
    // 业务域编号
    private EmdgBizLogDomainEnum domain;

    // 业务服务名称
    @ColumnName("service_name")
    private String serviceName;

    // 日志类型，用户操作，系统接口，外部HTTP接口，RPC接口，其他
    @ColumnName("log_type")
    private EmdgBizLogTypeEnum logType;

    // 操作类型，创建，更新，删除，查询，导出，导入，其他
    private EmdgBizLogActionEnum action;

    // 操作人，用户，服务，系统，其他
    private String operator;

    // 用户调用，服务内部调用，系统域调用
    @ColumnName("operator_type")
    private EmdgBizLogOperatorEnum operatorType;

    // 原始单据的主键ID
    @ColumnName("doc_id")
    private Long docId;

    // 原始单据的编号
    @ColumnName("doc_no")
    private String docNo;

    // 原始单据的类型
    @ColumnName("doc_type")
    private String docType;

    // -- 请求信息
    // 客户端IP
    @ColumnName("client_ip")
    private String clientIp;

    // HTTP请求方式, GET, POST, PUT, DELETE, RPC, 其他
    @ColumnName("request_type")
    private EmdgBizLogReqMethodEnum requestType;

    // HTTP或RPC请求地址
    @ColumnName("request_url")
    private String requestUrl;

    // HTTP请求头
    @ColumnName("request_header")
    private String requestHeader;

    // 调用发送的业务数据，用于所有的调用入参数据
    @ColumnName("request_body")
    private String requestBody;

    // -- 响应信息
    // HTTP响应的状态码
    @ColumnName("resp_status_code")
    private String respStatusCode;

    // HTTP响应头
    @ColumnName("resp_header")
    private String respHeader;

    // 调用返回的业务数据，用于所有的调用返回数据
    @ColumnName("resp_body")
    private String respBody;

    // -- 调用状态和时间
    // 调用是否成功，true/false
    private boolean success;

    // 调用开始时间
    @ColumnName("start_time")
    private LocalDateTime startTime;

    // 调用结束时间
    @ColumnName("end_time")
    private LocalDateTime endTime;

    // 调用耗时，单位毫秒
    @ColumnName("cost_time")
    private long costTime;

    // -- 异常信息
    // 调用异常编码，业务异常编码，系统异常编码，其他
    @ColumnName("error_code")
    private EmdgBizLogErrorEnum errorCode;

    // 调用异常堆栈信息
    @ColumnName("exception_stack")
    private String exceptionStack;

    // 日志时间
    @ColumnName("log_time")
    private LocalDateTime logTime;
}
