package com.elitesland.yst.emdg.common.model;

import com.fasterxml.jackson.annotation.JsonValue;

public enum EmdgBizLogErrorEnum {
    SERVER_ERROR("服务错误"),
    UNAUTHORIZED("未授权"),
    FORBIDDEN("禁止访问"),
    NOT_FOUND("未找到"),
    BAD_REQUEST("错误的请求"),
    METHOD_NOT_ALLOWED("非法调用"),
    REQUEST_TIMEOUT("请求超时"),
    TOO_MANY_REQUESTS("请求次数过多"),
    INTERNAL_SERVER_ERROR("服务内部错误"),
    BAD_GATEWAY("网关错误"),
    SERVICE_UNAVAILABLE("当前服务不可用"),
    GATEWAY_TIMEOUT("网关超时"),
    HTTP_VERSION_NOT_SUPPORTED("HTTP版本不支持"),
    UNKNOWN_ERROR("未知错误"),
    OTHER("其他错误");

    private final String desc;

    EmdgBizLogErrorEnum(String desc) {
        this.desc = desc;
    }

    @JsonValue
    public String getDesc() {
        return this.desc;
    }
}
